/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.gyrex.http.internal.application.gateway.HttpGatewayBinding;
import org.eclipse.gyrex.http.internal.application.gateway.IHttpGateway;
import org.eclipse.gyrex.http.internal.application.gateway.IUrlRegistry;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandlerCollection;
import org.eclipse.gyrex.http.jetty.internal.app.UrlRegistry;
import org.eclipse.gyrex.http.jetty.internal.handlers.DefaultErrorHandler;
import org.eclipse.gyrex.http.jetty.internal.handlers.DefaultErrorHandlerResourcesHandler;
import org.eclipse.gyrex.http.jetty.internal.handlers.DefaultFaviconHandler;
import org.eclipse.gyrex.http.jetty.internal.handlers.DefaultHandler;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyGateway
implements IHttpGateway {
    private static final Logger LOG = LoggerFactory.getLogger(JettyGateway.class);
    private final ConcurrentMap<HttpGatewayBinding, UrlRegistry> urlRegistryByManager = new ConcurrentHashMap<HttpGatewayBinding, UrlRegistry>(1);
    private final Server server;
    private final ApplicationHandlerCollection appHandlerCollection;
    private final File logsBaseDirectory;

    public JettyGateway(Server server) {
        this.server = server;
        this.logsBaseDirectory = Platform.getInstanceLocation().append("logs").append("jetty").toFile();
        this.logsBaseDirectory.mkdirs();
        HandlerCollection serverHandlers = new HandlerCollection();
        serverHandlers.addHandler((Handler)new DefaultErrorHandlerResourcesHandler());
        DefaultErrorHandler errorHandler = new DefaultErrorHandler();
        errorHandler.setServer(server);
        server.addBean((Object)errorHandler);
        this.appHandlerCollection = new ApplicationHandlerCollection(this);
        serverHandlers.addHandler((Handler)this.appHandlerCollection);
        serverHandlers.addHandler((Handler)new DefaultFaviconHandler());
        serverHandlers.addHandler((Handler)new DefaultHandler());
        server.setHandler((Handler)serverHandlers);
    }

    public boolean addApplicationHandlerIfAbsent(Handler handler) throws Exception {
        boolean added = this.appHandlerCollection.addIfAbsent(handler);
        this.appHandlerCollection.mapUrls();
        if (JettyDebug.handlers) {
            LOG.debug("{} URL handler {}", (Object)(added ? "Added" : "Updated"), (Object)handler);
            LOG.debug(this.server.dump());
        }
        return added;
    }

    public void close() {
        this.urlRegistryByManager.clear();
    }

    public Handler customize(ApplicationHandler applicationHandler) {
        HandlerCollection applicationHandlers = new HandlerCollection();
        applicationHandlers.addHandler((Handler)applicationHandler);
        File appLogDir = new File(this.logsBaseDirectory, applicationHandler.getApplicationId());
        appLogDir.mkdirs();
        NCSARequestLog requestLog = new NCSARequestLog();
        requestLog.setFilename(new File(appLogDir, "yyyy_mm_dd.request.log").getAbsolutePath());
        requestLog.setFilenameDateFormat("yyyy_MM_dd");
        requestLog.setRetainDays(90);
        requestLog.setAppend(true);
        requestLog.setExtended(true);
        requestLog.setLogCookies(false);
        requestLog.setLogTimeZone("GMT");
        RequestLogHandler logHandler = new RequestLogHandler();
        logHandler.setRequestLog((RequestLog)requestLog);
        applicationHandlers.addHandler((Handler)logHandler);
        return applicationHandlers;
    }

    public ApplicationHandler getApplicationHandler(Handler customizedHandler) {
        if (customizedHandler instanceof ApplicationHandler) {
            return (ApplicationHandler)customizedHandler;
        }
        if (customizedHandler instanceof HandlerContainer) {
            return (ApplicationHandler)((HandlerContainer)customizedHandler).getChildHandlerByClass(ApplicationHandler.class);
        }
        throw new IllegalArgumentException("unsupported handler: " + customizedHandler);
    }

    public String getName() {
        return "Jetty " + Server.getVersion();
    }

    public Server getServer() {
        return this.server;
    }

    public IUrlRegistry getUrlRegistry(HttpGatewayBinding applicationManager) {
        UrlRegistry registry = (UrlRegistry)this.urlRegistryByManager.get(applicationManager);
        if (registry != null) {
            return registry;
        }
        this.urlRegistryByManager.putIfAbsent(applicationManager, new UrlRegistry(this, applicationManager));
        return (IUrlRegistry)this.urlRegistryByManager.get(applicationManager);
    }

    public boolean removeApplicationHandler(Handler appHandler, boolean force) throws Exception {
        boolean removed = false;
        if (force || !this.getApplicationHandler(appHandler).hasUrls()) {
            this.appHandlerCollection.removeHandler(appHandler);
            removed = true;
        }
        this.appHandlerCollection.mapUrls();
        if (JettyDebug.handlers) {
            LOG.debug("{} URL handler {}", (Object)(removed ? "Removed" : "Updated"), (Object)appHandler);
            LOG.debug(this.server.dump());
        }
        return removed;
    }
}

