/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.boot.internal.BootActivator;
import org.eclipse.gyrex.common.services.ServiceNotAvailableException;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.slf4j.LoggerFactory;

public class LogbackLevelDebugOptionsBridge {
    private static final String MAIN_BUNDLE_DEBUG_OPTION = "/debug";
    final ConcurrentMap<String, String[]> overriddenLogLevels = new ConcurrentHashMap<String, String[]>();

    public static String getLoggerNameForDebugOption(String debugOption) {
        if (debugOption == null) {
            return null;
        }
        if (!debugOption.endsWith(MAIN_BUNDLE_DEBUG_OPTION)) {
            return null;
        }
        return StringUtils.removeEnd((String)debugOption, (String)MAIN_BUNDLE_DEBUG_OPTION);
    }

    LogbackLevelDebugOptionsBridge() {
    }

    void initializeLogLevelOverrides() throws Exception {
        this.overriddenLogLevels.clear();
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager sm = lc.getStatusManager();
        if (sm != null) {
            sm.add((Status)new InfoStatus("Initializing log level overrides.", (Object)this));
        }
        try {
            Map options = ((DebugOptions)BootActivator.getInstance().getService(DebugOptions.class)).getOptions();
            for (Map.Entry e : options.entrySet()) {
                String loggerName = LogbackLevelDebugOptionsBridge.getLoggerNameForDebugOption((String)e.getKey());
                if (loggerName == null || e.getValue() == null || "false".equalsIgnoreCase((String)e.getValue())) continue;
                this.setLogLevelOverride(loggerName, "DEBUG");
            }
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {
            // empty catch block
        }
    }

    void setLogLevelOverride(String loggerName, String level) throws Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager sm = lc.getStatusManager();
        Logger logger = lc.getLogger(loggerName);
        Level currentLevel = logger.getLevel();
        Level newLevel = Level.toLevel((String)level, null);
        if (newLevel == null) {
            String[] removed = (String[])this.overriddenLogLevels.remove(loggerName);
            if (removed != null) {
                Level toRestore = Level.toLevel((String)removed[1], null);
                if (sm != null) {
                    sm.add((Status)new InfoStatus(String.format("Resetting level for logger '%s'.", loggerName, logger.getEffectiveLevel()), (Object)this));
                }
                logger.setLevel(toRestore);
            }
        } else if (newLevel != currentLevel) {
            this.overriddenLogLevels.put(loggerName, new String[]{level, currentLevel != null ? currentLevel.levelStr : null});
            if (sm != null) {
                sm.add((Status)new InfoStatus(String.format("Overriding level for logger '%s' to '%s'.", loggerName, newLevel), (Object)this));
            }
            logger.setLevel(newLevel);
        }
    }
}

