/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.registry.JobProviderRegistry;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class JobsActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.jobs";
    private static final AtomicReference<JobsActivator> instanceRef = new AtomicReference();
    private volatile IServiceProxy<IQueueService> queueServiceProxy;
    private volatile JobProviderRegistry jobProviderRegistry;

    public static JobsActivator getInstance() {
        JobsActivator activator = instanceRef.get();
        if (activator == null) {
            throw new IllegalStateException("inactive");
        }
        return activator;
    }

    public static ServiceRegistration<MetricSet> registerMetrics(MetricSet metrics) {
        return JobsActivator.getInstance().getServiceHelper().registerService(MetricSet.class, (Object)metrics, "Eclipse Gyrex", metrics.getDescription(), null, null);
    }

    public JobsActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instanceRef.set(this);
        this.queueServiceProxy = this.getServiceHelper().trackService(IQueueService.class);
    }

    protected synchronized void doStop(BundleContext context) throws Exception {
        instanceRef.set(null);
        this.queueServiceProxy = null;
        if (this.jobProviderRegistry != null) {
            this.jobProviderRegistry.close();
            this.jobProviderRegistry = null;
        }
    }

    protected Class<?> getDebugOptions() {
        return JobsDebug.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobProviderRegistry getJobProviderRegistry() {
        JobProviderRegistry registry = this.jobProviderRegistry;
        if (registry == null) {
            JobsActivator jobsActivator = this;
            synchronized (jobsActivator) {
                if (this.jobProviderRegistry != null) {
                    return this.jobProviderRegistry;
                }
                if (!this.isActive()) {
                    throw this.createBundleInactiveException();
                }
                registry = this.jobProviderRegistry = new JobProviderRegistry(this.getBundle().getBundleContext());
                registry.open();
            }
        }
        return registry;
    }

    public IQueueService getQueueService() {
        IServiceProxy<IQueueService> proxy = this.queueServiceProxy;
        if (proxy == null) {
            throw this.createBundleInactiveException();
        }
        return (IQueueService)proxy.getService();
    }

    public void removeService(Object service) {
    }
}

