/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.spdy.Controller;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IdleListener;
import org.eclipse.jetty.spdy.StandardCompressionFactory;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.client.SPDYClient;
import org.eclipse.jetty.spdy.client.SPDYConnection;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;

public class SPDYClientConnectionFactory {
    public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) {
        SPDYClient.SessionPromise sessionPromise = (SPDYClient.SessionPromise)((Object)attachment);
        SPDYClient client = sessionPromise.client;
        SPDYClient.Factory factory = client.factory;
        ByteBufferPool bufferPool = factory.getByteBufferPool();
        StandardCompressionFactory compressionFactory = new StandardCompressionFactory();
        Parser parser = new Parser(compressionFactory.newDecompressor());
        Generator generator = new Generator(bufferPool, compressionFactory.newCompressor());
        ClientSPDYConnection connection = new ClientSPDYConnection(endPoint, bufferPool, parser, factory, client.isExecuteOnFillable());
        FlowControlStrategy flowControlStrategy = client.newFlowControlStrategy();
        StandardSession session = new StandardSession(client.version, bufferPool, factory.getExecutor(), factory.getScheduler(), (Controller)connection, endPoint, (IdleListener)connection, 1, sessionPromise.listener, generator, flowControlStrategy);
        session.setWindowSize(client.getInitialWindowSize());
        parser.addListener((Parser.Listener)session);
        sessionPromise.succeeded(session);
        connection.setSession((ISession)session);
        factory.sessionOpened((Session)session);
        return connection;
    }

    private class ClientSPDYConnection
    extends SPDYConnection {
        private final SPDYClient.Factory factory;

        public ClientSPDYConnection(EndPoint endPoint, ByteBufferPool bufferPool, Parser parser, SPDYClient.Factory factory, boolean executeOnFillable) {
            super(endPoint, bufferPool, parser, factory.getExecutor(), executeOnFillable);
            this.factory = factory;
        }

        public void onClose() {
            super.onClose();
            this.factory.sessionClosed((Session)this.getSession());
        }
    }
}

