/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.preferences.internal.console;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.preferences.internal.util.EclipsePreferencesUtil;
import org.kohsuke.args4j.Argument;
import org.osgi.service.prefs.Preferences;

public abstract class PathBasedCmd
extends Command {
    @Argument(index=0, required=true, metaVar="PATH", usage="path to a preference node")
    protected String path;

    public PathBasedCmd(String description) {
        super("<path> " + description);
    }

    protected void doExecute() throws Exception {
        IPreferencesService preferencesService = EclipsePreferencesUtil.getPreferencesService();
        String[] decodedPath = EclipsePreferencesUtil.decodePath(StringUtils.trimToEmpty((String)this.path));
        if (!preferencesService.getRootNode().nodeExists(String.valueOf(StringUtils.trimToEmpty((String)decodedPath[0])) + "/" + decodedPath[1])) {
            this.printf("ERROR: The specified node does not exist!", new Object[0]);
            return;
        }
        Preferences node = preferencesService.getRootNode().node(String.valueOf(StringUtils.trimToEmpty((String)decodedPath[0])) + "/" + decodedPath[1]);
        this.doExecute(node);
    }

    protected abstract void doExecute(Preferences var1) throws Exception;
}

