/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux.op;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxControlBlock;

public class MuxAddChannelRequest
implements MuxControlBlock {
    public static final byte IDENTITY_ENCODING = 0;
    public static final byte DELTA_ENCODING = 1;
    private long channelId = -1L;
    private byte encoding;
    private ByteBuffer handshake;
    private byte rsv;

    public long getChannelId() {
        return this.channelId;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public ByteBuffer getHandshake() {
        return this.handshake;
    }

    public long getHandshakeSize() {
        if (this.handshake == null) {
            return 0L;
        }
        return this.handshake.remaining();
    }

    @Override
    public int getOpCode() {
        return 0;
    }

    public byte getRsv() {
        return this.rsv;
    }

    public boolean isDeltaEncoded() {
        return this.encoding == 1;
    }

    public boolean isIdentityEncoded() {
        return this.encoding == 0;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    public void setEncoding(byte enc) {
        this.encoding = enc;
    }

    public void setHandshake(ByteBuffer handshake) {
        this.handshake = handshake == null ? null : handshake.slice();
    }

    public void setHandshake(String rawstring) {
        this.setHandshake(BufferUtil.toBuffer((String)rawstring, (Charset)StringUtil.__UTF8_CHARSET));
    }

    public void setRsv(byte rsv) {
        this.rsv = rsv;
    }
}

