/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.handlers;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.http.jetty.internal.handlers.ErrorPage;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class DefaultHandler
extends AbstractHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        baseRequest.setHandled(true);
        if (!HttpMethod.GET.is(request.getMethod())) {
            response.sendError(404);
            return;
        }
        ErrorPage errorPage = new ErrorPage(){

            @Override
            protected void writeDebugInfo(HttpServletRequest request, Writer writer) throws IOException {
                Handler[] handlers;
                writer.write("<hr>");
                writer.write("<h1>Welcome to Gyrex!</h1>");
                writer.write("<img src=\"/_error/gyrex-logo.png\" style=\"float:right;padding-left:1em;\">");
                writer.write("<p>If you see this page you know your server is running. It didn't handle the current request, though. You can start deploying applications or read about the latest buzz at <a href=\"http://planeteclipse.org/\">Planet Eclipse</a>!</p>");
                writer.write("<p>Useful links:");
                writer.write("<ul>");
                writer.write("<li><a href=\"http://wiki.eclipse.org/Gyrex/Administrator_Guide/\">Administrator Guide</a></li>");
                writer.write("<li><a href=\"http://www.eclipse.org/gyrex/documentation/\">Documentation Hub</a></li>");
                writer.write("<li><a href=\"http://www.eclipse.org/forums/eclipse.gyrex/\">User Forum</a></li>");
                writer.write("</ul></p>");
                writer.write("<div style=\"clear:both;\"></div>");
                writer.write("<hr>");
                writer.write("\n");
                Server server = DefaultHandler.this.getServer();
                Handler[] handlerArray = handlers = server == null ? null : server.getChildHandlersByClass(ApplicationHandler.class);
                if (handlers.length > 0) {
                    writer.write("<p>Applications known to this server are: <ul>");
                    writer.write("\n");
                    int i = 0;
                    while (handlers != null && i < handlers.length) {
                        String[] urls;
                        writer.write("<li>");
                        ApplicationHandler appHandler = (ApplicationHandler)handlers[i];
                        writer.write(appHandler.getApplicationId());
                        writer.write(" (");
                        writer.write(appHandler.getApplicationRegistration().getProviderId());
                        writer.write(")");
                        if (appHandler.isRunning()) {
                            writer.write(" [running]");
                        } else {
                            if (appHandler.isFailed()) {
                                writer.write(" [failed]");
                            }
                            if (appHandler.isStopped()) {
                                writer.write(" [stopped]");
                            }
                        }
                        String[] stringArray = urls = appHandler.getUrls();
                        int n = urls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String url = stringArray[n2];
                            writer.write(String.format("<br><small> --&gt; <a href=\"%s\">%s</a></small>", url, url));
                            ++n2;
                        }
                        writer.write("</li>");
                        writer.write("\n");
                        ++i;
                    }
                    writer.write("</ul></p>");
                    writer.write("\n");
                } else {
                    writer.write("<p>No applications known to this server!</p>");
                    writer.write("\n");
                }
                if (JettyDebug.handlers) {
                    writer.write("<pre>");
                    writer.write("\n");
                    server.dump((Appendable)writer);
                    writer.write("</pre>");
                    writer.write("\n");
                }
            }
        };
        errorPage.setCode(404);
        errorPage.setOfficialMessage(HttpStatus.getMessage((int)404));
        errorPage.setInternalMessage("No applications on this server matched or handled this request.");
        response.setStatus(404);
        errorPage.render(request, response);
    }
}

