/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal;

import java.io.ByteArrayOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.SystemUtils;
import org.apache.zookeeper.CreateMode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.CloudState;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMetricsReporter
extends Job
implements IShutdownParticipant {
    private static final long DELAY = 60000L;
    private static final NodeMetricsReporter instance = new NodeMetricsReporter();
    private static final Logger LOG = LoggerFactory.getLogger(NodeMetricsReporter.class);

    private static String getUsingReflection(Object bean, String methodName) {
        Object result;
        block3: {
            try {
                Method method = bean.getClass().getMethod(methodName, null);
                result = method.invoke((Object)method, null);
                if (result != null) break block3;
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        return String.valueOf(result);
    }

    static void start() {
        if (CloudDebug.nodeMetrics) {
            LOG.debug("Starting node metrics report job.");
        }
        CloudActivator activator = CloudActivator.getInstance();
        instance.schedule(60000L);
        activator.addShutdownParticipant(instance);
    }

    static void stop() {
        if (CloudDebug.nodeMetrics) {
            LOG.debug("Stopping node metrics report job.");
        }
        CloudActivator activator = CloudActivator.getInstance();
        instance.cancel();
        activator.removeShutdownParticipant(instance);
    }

    private NodeMetricsReporter() {
        super("Node Metrics Reporter");
        this.setSystem(true);
        this.setPriority(50);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            try {
                Properties metrics = new Properties(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public synchronized Enumeration<Object> keys() {
                        return Collections.enumeration(this.keySet());
                    }

                    @Override
                    public Set<Object> keySet() {
                        return new TreeSet<Object>(super.keySet());
                    }
                };
                OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                metrics.setProperty("os.availableProcessors", String.valueOf(operatingSystemMXBean.getAvailableProcessors()));
                metrics.setProperty("os.systemLoadAverage", String.valueOf(operatingSystemMXBean.getSystemLoadAverage()));
                metrics.setProperty("os.committedVirtualMemorySize", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getCommittedVirtualMemorySize"));
                metrics.setProperty("os.totalSwapSpaceSize", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getTotalSwapSpaceSize"));
                metrics.setProperty("os.freeSwapSpaceSize", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getFreeSwapSpaceSize"));
                metrics.setProperty("os.processCpuTime", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getProcessCpuTime"));
                metrics.setProperty("os.freePhysicalMemorySize", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getFreePhysicalMemorySize"));
                metrics.setProperty("os.totalPhysicalMemorySize", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getTotalPhysicalMemorySize"));
                metrics.setProperty("os.openFileDescriptorCount", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getOpenFileDescriptorCount"));
                metrics.setProperty("os.maxFileDescriptorCount", NodeMetricsReporter.getUsingReflection(operatingSystemMXBean, "getMaxFileDescriptorCount"));
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
                metrics.setProperty("heap.used", String.valueOf(heapMemoryUsage.getUsed()));
                metrics.setProperty("heap.committed", String.valueOf(heapMemoryUsage.getCommitted()));
                metrics.setProperty("heap.max", String.valueOf(heapMemoryUsage.getMax()));
                metrics.setProperty("heap.init", String.valueOf(heapMemoryUsage.getInit()));
                MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
                metrics.setProperty("nonHeap.used", String.valueOf(nonHeapMemoryUsage.getUsed()));
                metrics.setProperty("nonHeap.committed", String.valueOf(nonHeapMemoryUsage.getCommitted()));
                metrics.setProperty("nonHeap.max", String.valueOf(nonHeapMemoryUsage.getMax()));
                metrics.setProperty("nonHeap.init", String.valueOf(nonHeapMemoryUsage.getInit()));
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                metrics.setProperty("thread.count", String.valueOf(threadMXBean.getThreadCount()));
                metrics.setProperty("thread.peak", String.valueOf(threadMXBean.getPeakThreadCount()));
                metrics.setProperty("thread.totalStarted", String.valueOf(threadMXBean.getTotalStartedThreadCount()));
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                metrics.setProperty("uptime", String.valueOf(runtimeMXBean.getUptime()));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                NodeInfo nodeInfo = CloudState.getNodeInfo();
                metrics.store(out, String.valueOf(nodeInfo));
                ZooKeeperGate.get().writeRecord(IZooKeeperLayout.PATH_NODES_METRICS.append(nodeInfo.getNodeId()), CreateMode.PERSISTENT, out.toByteArray());
                if (CloudDebug.nodeMetrics) {
                    LOG.debug("Node metrics reported successfully.{}{}", (Object)SystemUtils.LINE_SEPARATOR, (Object)new String(out.toByteArray(), "ISO-8859-1"));
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to update node metrics. {}", (Object)e.getMessage());
                this.schedule(60000L);
            }
        }
        finally {
            this.schedule(60000L);
        }
        return Status.OK_STATUS;
    }

    public void shutdown() throws Exception {
        this.cancel();
    }
}

