/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk.console;

import java.util.Date;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.gyrex.cloud.internal.zk.console.PathBasedCmd;

public class StatCmd
extends PathBasedCmd {
    public StatCmd() {
        super("- prints ZK stats of the specified path");
    }

    @Override
    protected void doExecute(ZooKeeper zk, String path) throws Exception {
        Stat stat = zk.exists(path, false);
        this.ci.println((Object)("cZxid: 0x" + Long.toHexString(stat.getCzxid())));
        this.ci.println((Object)("ctime: " + new Date(stat.getCtime()).toString()));
        this.ci.println((Object)("mZxid: 0x" + Long.toHexString(stat.getMzxid())));
        this.ci.println((Object)("mtime: " + new Date(stat.getMtime()).toString()));
        this.ci.println((Object)("pZxid: 0x" + Long.toHexString(stat.getPzxid())));
        this.ci.println((Object)("cversion: " + stat.getCversion()));
        this.ci.println((Object)("dataVersion: " + stat.getVersion()));
        this.ci.println((Object)("aclVersion: " + stat.getAversion()));
        this.ci.println((Object)("ephemeralOwner: 0x" + Long.toHexString(stat.getEphemeralOwner())));
        this.ci.println((Object)("dataLength: " + stat.getDataLength()));
        this.ci.println((Object)("numChildren: " + stat.getNumChildren()));
    }
}

