/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.configuration;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ContextConfiguration.class);
    public static final String CONTEXTS = "contexts";
    public static final IPath CONTEXT_PREF_ROOT = new Path("org.eclipse.gyrex.context").append("contexts").makeRelative();

    /*
     * Unable to fully structure code
     */
    public static String findFilter(IPath contextPath, String typeName) {
        rootNode = ContextConfiguration.getRootNodeForContextPreferences();
        filter = ContextConfiguration.readFilterFromPreferences(rootNode, contextPath, typeName);
        if (filter == null) ** GOTO lbl7
        return filter;
lbl-1000:
        // 1 sources

        {
            contextPath = contextPath.removeLastSegments(1);
            filter = ContextConfiguration.readFilterFromPreferences(rootNode, contextPath, typeName);
lbl7:
            // 2 sources

            ** while (filter == null && !contextPath.isRoot())
        }
lbl8:
        // 1 sources

        return filter;
    }

    private static String getPreferencesPathForContextObjectFilterSetting(IPath contextPath) {
        return contextPath.makeRelative().toString();
    }

    public static IEclipsePreferences getRootNodeForContextPreferences() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.context").node(CONTEXTS);
    }

    private static String readFilterFromPreferences(IEclipsePreferences root, IPath contextPath, String typeName) {
        String preferencesPath = ContextConfiguration.getPreferencesPathForContextObjectFilterSetting(contextPath);
        try {
            if (!root.nodeExists(preferencesPath)) {
                return null;
            }
        }
        catch (BackingStoreException e) {
            LOG.warn("Error while accessing the preferences backend for context path \"{}\": {}", (Object)contextPath, (Object)e.getMessage());
            return null;
        }
        String filterString = root.node(preferencesPath).get(typeName, null);
        if (filterString == null) {
            return null;
        }
        return filterString;
    }

    public static void setFilter(IRuntimeContext context, String typeName, String filter) {
        IPath contextPath = context.getContextPath();
        IEclipsePreferences rootNode = ContextConfiguration.getRootNodeForContextPreferences();
        if (ContextDebug.objectLifecycle) {
            LOG.debug("Setting filter in context {} for type {} to {}", new Object[]{context, typeName, filter});
        }
        String preferencesPath = ContextConfiguration.getPreferencesPathForContextObjectFilterSetting(contextPath);
        try {
            Preferences contextPreferences = rootNode.node(preferencesPath);
            if (filter != null) {
                contextPreferences.put(typeName, filter);
            } else {
                contextPreferences.remove(typeName);
            }
            contextPreferences.flush();
        }
        catch (BackingStoreException e) {
            LOG.warn("Error while accessing the preferences backend for context path \"{}\": {}", (Object)contextPath, (Object)e.getMessage());
        }
    }

    private ContextConfiguration() {
    }
}

