/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.widgets;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class DropDownItem
extends Composite {
    private static final long serialVersionUID = 1L;
    private final String text;
    private final String customVariant;
    private final ToolBar toolBar;
    private final ToolItem toolItem;
    private boolean selected;
    private boolean open;

    public DropDownItem(Composite parent, String text, String customVariant) {
        super(parent, 0);
        this.text = text;
        this.customVariant = customVariant;
        this.setLayout((Layout)new FillLayout());
        this.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.toolBar = new ToolBar((Composite)this, 256);
        this.toolBar.setData("org.eclipse.rap.rwt.customVariant", (Object)customVariant);
        this.toolItem = new ToolItem(this.toolBar, 4);
        this.toolItem.setData("org.eclipse.rap.rwt.customVariant", (Object)customVariant);
        this.toolItem.setText(text.replace("&", "&&"));
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                DropDownItem.this.toolItemSelected(DropDownItem.this.toolBar, event);
            }
        });
    }

    protected String getCustomVariant() {
        return this.customVariant;
    }

    public String getText() {
        return this.text;
    }

    public ToolItem getToolItem() {
        return this.toolItem;
    }

    protected abstract void openDropDown(Point var1);

    public void setOpen(boolean open) {
        this.open = open;
        this.updateCustomVariant();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.updateCustomVariant();
    }

    void toolItemSelected(ToolBar toolBar, SelectionEvent event) {
        Rectangle pos = ((ToolItem)event.getSource()).getBounds();
        this.openDropDown(toolBar.toDisplay(pos.x, pos.y + pos.height));
    }

    private void updateCustomVariant() {
        String variant = this.customVariant;
        if (this.selected) {
            variant = String.valueOf(variant) + "Selected";
        }
        if (this.open) {
            variant = String.valueOf(variant) + "Open";
        }
        this.toolItem.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
    }
}

