/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.adapter.AdapterUtil;
import org.eclipse.gyrex.admin.ui.adapter.ImageAdapter;
import org.eclipse.gyrex.admin.ui.internal.widgets.PatternFilter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.TreeListDialogField;
import org.eclipse.gyrex.admin.ui.logback.internal.AddEditAppenderWizard;
import org.eclipse.gyrex.admin.ui.logback.internal.AppenderType;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.logback.config.internal.AppenderProviderRegistry;
import org.eclipse.gyrex.logback.config.internal.LogbackConfigActivator;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.spi.AppenderProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AppenderWizardPage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    private final LabelProvider appenderTreeLabelProvider = new LabelProvider(){
        private static final long serialVersionUID = 1L;
        private LocalResourceManager resourceManager;

        private Image createImage(ImageDescriptor descriptor) {
            if (descriptor == null) {
                return null;
            }
            if (this.resourceManager == null) {
                this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
            }
            return this.resourceManager.createImage(descriptor);
        }

        public void dispose() {
            super.dispose();
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
        }

        public Image getImage(Object element) {
            ImageAdapter adapter = (ImageAdapter)AdapterUtil.getAdapter((Object)element, ImageAdapter.class);
            if (adapter != null) {
                return this.createImage(adapter.getImageDescriptor(element));
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof AppenderType) {
                return ((AppenderType)element).getName();
            }
            return super.getText(element);
        }
    };
    private final ITreeListAdapter appenderTreeListAdapter = new ITreeListAdapter(){

        public void customButtonPressed(TreeListDialogField field, int index) {
        }

        public void doubleClicked(TreeListDialogField field) {
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            return new Object[0];
        }

        public Object getParent(TreeListDialogField field, Object element) {
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return false;
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public void selectionChanged(TreeListDialogField field) {
            AppenderWizardPage.this.validate();
        }
    };
    private final TreeListDialogField appenderTypeField = new TreeListDialogField(this.appenderTreeListAdapter, null, (ILabelProvider)this.appenderTreeLabelProvider, new PatternFilter());
    private final StringDialogField nameField = new StringDialogField();
    private final Appender appender;

    protected AppenderWizardPage(Appender appender) {
        super("type");
        this.appender = appender;
        this.setTitle("Appender");
        this.setDescription("Configure the appender basics (such as name and type).");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.nameField.setLabelText("Name:");
        this.appenderTypeField.setLabelText("Type:");
        this.appenderTypeField.setViewerComparator(new ViewerComparator());
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AppenderWizardPage.this.validate();
            }
        };
        this.nameField.setDialogFieldListener(validateListener);
        this.appenderTypeField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.nameField, this.appenderTypeField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.appenderTypeField.getTreeControl(null));
        ArrayList<AppenderType> types = new ArrayList<AppenderType>();
        AppenderProviderRegistry registry = LogbackConfigActivator.getInstance().getAppenderProviderRegistry();
        for (AppenderProvider provider : registry.getTracked().values()) {
            for (String typeId : provider.getProvidedTypeIds()) {
                types.add(new AppenderType(typeId, registry.getName(typeId), provider));
            }
        }
        this.appenderTypeField.setElements(types);
        if (this.appender != null) {
            this.nameField.setText(this.appender.getName());
            for (AppenderType type : types) {
                if (!this.appender.getTypeId().equals(type.getId())) continue;
                this.appenderTypeField.selectElements((ISelection)new StructuredSelection((Object)type));
                break;
            }
            this.appenderTypeField.setEnabled(false);
        }
    }

    public String getName() {
        return StringUtils.trimToNull((String)this.nameField.getText());
    }

    private void setAppenderType(AppenderType type) {
        AddEditAppenderWizard wizard = (AddEditAppenderWizard)this.getWizard();
        if (type != null) {
            wizard.initializeCurrentAppenderConfigurationSession(type.getId(), type.getName(), type.getWizardAdapter());
        } else {
            wizard.clearCurrentAppenderConfigurationSession();
        }
    }

    void validate() {
        String name = this.getName();
        if (name == null) {
            this.setMessage("Please enter an appender name.", 1);
            this.setPageComplete(false);
            return;
        }
        if (!IdHelper.isValidId((String)name)) {
            this.setMessage("The entered appender name is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.", 3);
            this.setPageComplete(false);
            return;
        }
        List selectedElements = this.appenderTypeField.getSelectedElements();
        if (selectedElements.size() != 1) {
            this.setMessage("Please select an appender to use.", 1);
            this.setPageComplete(false);
            return;
        }
        this.setAppenderType((AppenderType)selectedElements.get(0));
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

