/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.logback.internal.LogbackLabelProvider;
import org.eclipse.gyrex.admin.ui.logback.internal.SelectAppenderDialog;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoggerSettingsDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField nameField = new StringDialogField();
    private final SelectionButtonDialogField inheritAppendersField = new SelectionButtonDialogField(32);
    private final SelectionButtonDialogFieldGroup levelField = new SelectionButtonDialogFieldGroup(16, new String[]{"ALL", "DEBUG", "INFO", "WARN", "ERROR", "OFF"}, 6);
    private final ListDialogField appenderRefsField = new ListDialogField(new IListAdapter(){

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                LoggerSettingsDialog.this.addAppenderRefButtonPressed();
            }
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void selectionChanged(ListDialogField field) {
        }
    }, new String[]{"Add...", "Remove"}, (ILabelProvider)new LogbackLabelProvider());
    private final boolean isRoot;
    private final String originalName;
    private final Level originalLevel;
    private final boolean originalInherit;
    private final Collection<String> originalAppenderRefs;
    private final Collection<Appender> allAvailableAppenders;
    private Logger logger;

    public LoggerSettingsDialog(Shell parent, Collection<Appender> allAvailableAppenders) {
        this(parent, null, null, true, null, allAvailableAppenders, false);
    }

    public LoggerSettingsDialog(Shell parent, Level defaultLevel, Collection<String> defaultAppenderRefs, Collection<Appender> allAvailableAppenders) {
        this(parent, null, defaultLevel, false, defaultAppenderRefs, allAvailableAppenders, true);
    }

    public LoggerSettingsDialog(Shell parent, String name, Level level, boolean inheritOtherAppenders, Collection<String> originalAppenderRefs, Collection<Appender> allAvailableAppenders) {
        this(parent, name, level, inheritOtherAppenders, originalAppenderRefs, allAvailableAppenders, false);
    }

    private LoggerSettingsDialog(Shell parent, String originalName, Level originalLevel, boolean originalInherit, Collection<String> originalAppenderRefs, Collection<Appender> allAvailableAppenders, boolean isRoot) {
        super(parent);
        this.originalName = originalName;
        this.originalLevel = originalLevel;
        this.originalInherit = originalInherit;
        this.originalAppenderRefs = originalAppenderRefs;
        this.allAvailableAppenders = allAvailableAppenders;
        this.isRoot = isRoot;
        if (isRoot) {
            this.setTitle("Default Logger Settings");
        } else {
            this.setTitle(originalLevel != null ? "Edit Logger" : "New Logger");
        }
        this.setShellStyle(67696);
    }

    void addAppenderRefButtonPressed() {
        final SelectAppenderDialog dialog = new SelectAppenderDialog(this.getShell(), this.allAvailableAppenders);
        dialog.openNonBlocking(new DialogCallback(){

            public void dialogClosed(int returnCode) {
                Appender appender;
                if (returnCode == 0 && (appender = (Appender)dialog.getFirstResult()) != null) {
                    if (LoggerSettingsDialog.this.appenderRefsField.getElements().contains(appender.getName())) {
                        return;
                    }
                    LoggerSettingsDialog.this.appenderRefsField.addElement((Object)appender.getName());
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.nameField.setLabelText("Name:");
        this.levelField.setLabelText("Level:");
        this.inheritAppendersField.setLabelText("Inherit appenders from parent loggers.");
        this.inheritAppendersField.setSelection(true);
        this.appenderRefsField.setLabelText("Appenders:");
        this.appenderRefsField.setRemoveButtonIndex(1);
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                LoggerSettingsDialog.this.validate();
            }
        };
        this.nameField.setDialogFieldListener(validateListener);
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.nameField, this.levelField, this.inheritAppendersField, this.appenderRefsField}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.levelField.getSelectionButtonsGroup(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.appenderRefsField.getListControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        if (this.isRoot) {
            this.nameField.setEnabled(false);
            this.nameField.setText("DEFAULT");
            this.inheritAppendersField.setEnabled(false);
            this.inheritAppendersField.setSelection(false);
        } else {
            if (this.originalName != null) {
                this.nameField.setText(this.originalName);
            }
            this.inheritAppendersField.setSelection(this.originalInherit);
        }
        if (this.originalLevel != null) {
            this.levelField.setSelection(0, false);
            this.levelField.setSelection(1, false);
            this.levelField.setSelection(2, false);
            this.levelField.setSelection(3, false);
            this.levelField.setSelection(4, false);
            this.levelField.setSelection(5, false);
            this.levelField.setSelection(6, false);
            switch (this.originalLevel.levelInt) {
                case -2147483648: {
                    this.levelField.setSelection(0, true);
                    break;
                }
                case 10000: {
                    this.levelField.setSelection(1, true);
                    break;
                }
                case 20000: {
                    this.levelField.setSelection(2, true);
                    break;
                }
                case 30000: {
                    this.levelField.setSelection(3, true);
                    break;
                }
                case 40000: {
                    this.levelField.setSelection(4, true);
                    break;
                }
                case 0x7FFFFFFF: {
                    this.levelField.setSelection(5, true);
                    break;
                }
            }
        }
        if (this.originalAppenderRefs != null) {
            this.appenderRefsField.setElements(new ArrayList<String>(this.originalAppenderRefs));
        }
        return composite;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            this.logger = new Logger();
            this.logger.setName(this.nameField.getText());
            if (this.levelField.isSelected(0)) {
                this.logger.setLevel(Level.ALL);
            } else if (this.levelField.isSelected(1)) {
                this.logger.setLevel(Level.DEBUG);
            } else if (this.levelField.isSelected(2)) {
                this.logger.setLevel(Level.INFO);
            } else if (this.levelField.isSelected(3)) {
                this.logger.setLevel(Level.WARN);
            } else if (this.levelField.isSelected(4)) {
                this.logger.setLevel(Level.ERROR);
            } else if (this.levelField.isSelected(5)) {
                this.logger.setLevel(Level.OFF);
            }
            this.logger.setInheritOtherAppenders(this.inheritAppendersField.isSelected());
            List elements = this.appenderRefsField.getElements();
            ArrayList<String> appenderRefs = new ArrayList<String>();
            for (Object appenderRef : elements) {
                if (!(appenderRef instanceof String) || appenderRefs.contains(appenderRef)) continue;
                appenderRefs.add((String)appenderRef);
            }
            this.logger.setAppenderReferences(appenderRefs);
        }
        catch (Exception e) {
            this.logger = null;
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.logback", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.logback", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.logback", message));
    }

    void validate() {
        String name = this.nameField.getText();
        if (StringUtils.isBlank((String)name)) {
            this.setInfo("Please enter a name.");
            return;
        }
        if (!IdHelper.isValidId((String)name)) {
            this.setError("The entered appender name is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        if (!this.levelField.isAnySelected()) {
            this.setInfo("Please select a log level.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

