/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.manager.StorableBackedJobHistoryEntry;
import org.eclipse.gyrex.jobs.spi.storage.IJobHistoryStorage;
import org.eclipse.gyrex.jobs.spi.storage.JobHistoryEntryStorable;

public class PagableHistoryEntryCollection
extends AbstractCollection<IJobHistoryEntry> {
    final int totalEntryCount;
    final int pageSize;
    final int pages;
    final String jobId;
    final IJobHistoryStorage storage;

    public PagableHistoryEntryCollection(String jobId, IJobHistoryStorage storage, int pageSize) throws Exception {
        this.jobId = jobId;
        this.storage = storage;
        this.pageSize = Math.max(pageSize, 1);
        this.totalEntryCount = storage.count(jobId);
        this.pages = (int)Math.floor((double)this.totalEntryCount / (double)this.pageSize);
    }

    @Override
    public Iterator<IJobHistoryEntry> iterator() {
        return new PagableHistoryEntryIterator();
    }

    @Override
    public int size() {
        return this.totalEntryCount;
    }

    @Override
    public String toString() {
        return String.format("%s[ %s (%d) (using %s) ]", this.getClass().getSimpleName(), this.jobId, this.totalEntryCount, this.storage);
    }

    private final class PagableHistoryEntryIterator
    implements Iterator<IJobHistoryEntry> {
        int offset = 0;
        Iterator<JobHistoryEntryStorable> storablesIterator;

        private PagableHistoryEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.offset < PagableHistoryEntryCollection.this.totalEntryCount || this.storablesIterator != null && this.storablesIterator.hasNext();
        }

        @Override
        public IJobHistoryEntry next() {
            if (this.storablesIterator != null && this.storablesIterator.hasNext()) {
                return new StorableBackedJobHistoryEntry(this.storablesIterator.next());
            }
            if (this.offset >= PagableHistoryEntryCollection.this.totalEntryCount) {
                throw new NoSuchElementException();
            }
            try {
                this.storablesIterator = PagableHistoryEntryCollection.this.storage.find(PagableHistoryEntryCollection.this.jobId, this.offset, PagableHistoryEntryCollection.this.pageSize).iterator();
                this.offset += PagableHistoryEntryCollection.this.pageSize;
                return new StorableBackedJobHistoryEntry(this.storablesIterator.next());
            }
            catch (Exception e) {
                throw new IllegalStateException("Error accessing job history store.", e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.format("%s[ %s (total %d, offset %d, page size %d) (using %s) ]", this.getClass().getSimpleName(), PagableHistoryEntryCollection.this.jobId, PagableHistoryEntryCollection.this.totalEntryCount, this.offset, PagableHistoryEntryCollection.this.pageSize, PagableHistoryEntryCollection.this.storage);
        }
    }
}

