/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.FilteredItemsSelectionDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobType;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.registry.JobProviderRegistry;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class JobTypeSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final long serialVersionUID = 1L;

    public JobTypeSelectionDialog(Shell shell) {
        super(shell);
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){
            private static final long serialVersionUID = 1L;

            public String getText(Object element) {
                if (element instanceof JobType) {
                    return ((JobType)element).getName();
                }
                return super.getText(element);
            }
        });
        this.setInitialPattern("*");
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                if (item instanceof JobType) {
                    JobType type = (JobType)item;
                    return this.patternMatcher.matches(type.getName()) || this.patternMatcher.matches(type.getId());
                }
                return false;
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        JobProviderRegistry registry = JobsActivator.getInstance().getJobProviderRegistry();
        for (Map.Entry e : registry.getTracked().entrySet()) {
            JobProvider provider = (JobProvider)e.getValue();
            for (String typeId : provider.getProvidedTypeIds()) {
                contentProvider.add((Object)new JobType(typeId, registry.getName(typeId), provider), itemsFilter);
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings(JobTypeSelectionDialog.class.getName());
    }

    public String getElementName(Object item) {
        if (item instanceof JobType) {
            return ((JobType)item).getName();
        }
        return null;
    }

    protected Comparator<Object> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String id1 = null;
                String id2 = null;
                if (!(o1 instanceof JobType)) {
                    return 0;
                }
                id1 = ((JobType)o1).getName();
                if (!(o2 instanceof JobType)) {
                    return 0;
                }
                id2 = ((JobType)o2).getName();
                return id1.compareTo(id2);
            }
        };
    }

    public void openNonBlocking(DialogCallback callback) {
        super.openNonBlocking(callback);
        this.refresh();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }
}

