/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.commands;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.kohsuke.args4j.Argument;

public abstract class BaseContextDefinitionCmd
extends Command {
    @Argument(index=0, usage="the context path", required=true, metaVar="PATH")
    String pathStr;

    public BaseContextDefinitionCmd(String description) {
        super(description);
    }

    protected void doExecute() throws Exception {
        if (StringUtils.isBlank((String)this.pathStr) || !Path.EMPTY.isValidPath(this.pathStr)) {
            this.printf("ERROR: invalid path", new Object[0]);
            return;
        }
        ContextDefinition contextDefinition = this.getRegistry().getDefinition((IPath)new Path(this.pathStr));
        if (contextDefinition == null) {
            this.printf("ERROR: context does not exist", new Object[0]);
            return;
        }
        this.doExecute(contextDefinition);
    }

    protected abstract void doExecute(ContextDefinition var1) throws Exception;

    protected ContextRegistryImpl getRegistry() {
        return ContextActivator.getInstance().getContextRegistryImpl();
    }
}

