/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.di;

import java.lang.annotation.Annotation;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.IContextDisposalListener;
import org.eclipse.gyrex.context.internal.di.BaseContextObjectSupplier;
import org.eclipse.gyrex.context.provider.di.ExtendedObjectResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class GyrexContextObjectSupplier
extends BaseContextObjectSupplier {
    private final GyrexContextImpl contextImpl;

    public GyrexContextObjectSupplier(GyrexContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    @Override
    protected void addDisposable(IContextDisposalListener listener) {
        this.contextImpl.addDisposable(listener);
    }

    @Override
    protected Object getContextObject(Class<?> key) {
        if (key == null) {
            return null;
        }
        if (IRuntimeContext.class.equals(key)) {
            return this.contextImpl.getHandle();
        }
        return this.contextImpl.get(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object getQualifiedObjected(Class<?> type, Annotation annotation) {
        if (!(annotation.annotationType() instanceof Class)) {
            return null;
        }
        BundleContext bundleContext = ContextActivator.getInstance().getBundle().getBundleContext();
        String filter = "(dependency.injection.annotation=" + annotation.annotationType().getName() + ')';
        try {
            Collection refs = bundleContext.getServiceReferences(ExtendedObjectResolver.class, filter);
            if (refs.isEmpty()) return null;
            for (ServiceReference ref : refs) {
                ExtendedObjectResolver resolver = (ExtendedObjectResolver)bundleContext.getService(ref);
                if (resolver == null) continue;
                try {
                    Object result = resolver.get(type, this.contextImpl.getHandle(), annotation);
                    if (result == null) continue;
                    Object object = result;
                    return object;
                }
                finally {
                    bundleContext.ungetService(ref);
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(String.format("Error computing filter expression (%s) for annotation (%s). Please report Gyrex bug! (%s)", filter, annotation, e.getMessage()));
        }
    }

    @Override
    protected IServiceProxy<?> trackService(BundleContext bundleContext, Class<?> serviceInterface, String filter) throws InvalidSyntaxException {
        if (StringUtils.isNotBlank((String)filter)) {
            return this.contextImpl.getServiceLocator(bundleContext).trackService(serviceInterface, filter);
        }
        return this.contextImpl.getServiceLocator(bundleContext).trackService(serviceInterface);
    }
}

