/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.admin.ui.internal.AdminUiImages;
import org.eclipse.gyrex.admin.ui.internal.application.AdminApplicationConfiguration;
import org.eclipse.gyrex.admin.ui.internal.jetty.AdminServletHolder;
import org.eclipse.gyrex.admin.ui.internal.jetty.SimpleAdminLoginService;
import org.eclipse.gyrex.admin.ui.internal.servlets.AdminServletTracker;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.monitoring.diagnostics.StatusTracker;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.ApplicationRunner;
import org.eclipse.rap.rwt.engine.RWTServlet;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUiActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.admin.ui";
    private static final String IMAGE_REGISTRY = "org.eclipse.gyrex.admin.ui#imageRegistry";
    private static final int DEFAULT_ADMIN_PORT = 3110;
    private static final Logger LOG = LoggerFactory.getLogger(AdminUiActivator.class);
    private static volatile AdminUiActivator instance;
    private static volatile Server server;
    private static final String PROPERTY_ADMIN_SECURE = "gyrex.admin.secure";
    private static final String PROPERTY_ADMIN_AUTH = "gyrex.admin.auth";
    private ApplicationRunner adminApplicationRunner;
    private StatusTracker statusTracker;

    public static ImageDescriptor getImageDescriptor(String path) {
        return ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)instance.getBundle(), (IPath)new Path(path), null));
    }

    public static AdminUiActivator getInstance() {
        AdminUiActivator activator = instance;
        if (activator == null) {
            throw new IllegalStateException("inactive");
        }
        return activator;
    }

    public AdminUiActivator() {
        super(SYMBOLIC_NAME);
    }

    private void addNonSslConnector(Server server) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendDateHeader(false);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
        connector.setPort(3110);
        connector.setIdleTimeout(60000L);
        server.addConnector((Connector)connector);
    }

    private void addSslConnector(Server server) {
        try {
            File keystoreFile = Platform.getStateLocation((Bundle)AdminUiActivator.getInstance().getBundle()).append("jettycerts").toFile();
            if (!keystoreFile.isFile()) {
                if (!keystoreFile.getParentFile().isDirectory() && !keystoreFile.getParentFile().mkdirs()) {
                    throw new IllegalStateException("Error creating directory for jetty ssl certificates");
                }
                InputStream stream = this.getBundle().getEntry("cert/jettycerts.jks").openStream();
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)keystoreFile);
                IOUtils.closeQuietly((InputStream)stream);
            }
            SslContextFactory sslContextFactory = new SslContextFactory(keystoreFile.getCanonicalPath());
            sslContextFactory.setKeyStorePassword("changeit");
            sslContextFactory.setKeyManagerPassword("changeit");
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setSendServerVersion(false);
            httpConfiguration.setSendDateHeader(false);
            httpConfiguration.setSecurePort(3110);
            ServerConnector connector = new ServerConnector(server, sslContextFactory, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            connector.setPort(3110);
            connector.setIdleTimeout(60000L);
            server.addConnector((Connector)connector);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error configuring jetty ssl connector for admin ui.", e);
        }
    }

    private void configureContextWithServletsAndResources(ServletContextHandler contextHandler) throws MalformedURLException, IOException {
        IPath contextBase = Platform.getStateLocation((Bundle)this.getBundle()).append("context");
        contextHandler.setBaseResource(Resource.newResource((File)contextBase.toFile()));
        if (Platform.inDevelopmentMode()) {
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "true");
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.maxCachedFiles", "0");
        } else {
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.maxCacheSize", "2000000");
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.maxCachedFileSize", "254000");
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.maxCachedFiles", "1000");
            contextHandler.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "true");
        }
        this.adminApplicationRunner = new ApplicationRunner((ApplicationConfiguration)new AdminApplicationConfiguration(), (ServletContext)contextHandler.getServletContext());
        this.adminApplicationRunner.start();
        contextHandler.addServlet((ServletHolder)new AdminServletHolder((Servlet)new RWTServlet()), "/admin");
        AdminServletHolder staticResources = new AdminServletHolder((Servlet)new DefaultServlet());
        staticResources.setInitParameter("resourceBase", FileLocator.resolve((URL)FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("html"), null)).toExternalForm());
        contextHandler.addServlet((ServletHolder)staticResources, "/static/*");
        contextHandler.addServlet((ServletHolder)new AdminServletHolder((Servlet)new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.sendRedirect("/admin");
            }
        }), "");
        contextHandler.addServlet((ServletHolder)new AdminServletHolder((Servlet)new DefaultServlet()), "/*");
        try {
            Class servletClass = AdminUiActivator.getInstance().getBundle().loadClass("ch.qos.logback.classic.ViewStatusMessagesServlet");
            contextHandler.addServlet((ServletHolder)new AdminServletHolder((Servlet)servletClass.newInstance()), "/logbackstatus");
        }
        catch (ClassNotFoundException | LinkageError e) {
            LOG.warn("Logback status servlet not available. {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            LOG.error("An error occurred while registering the Logback status servlet. {}", (Object)e.getMessage(), (Object)e);
        }
        final AdminServletTracker adminServletTracker = new AdminServletTracker(this.getBundle().getBundleContext(), contextHandler);
        contextHandler.addBean((Object)new AbstractLifeCycle(){

            protected void doStart() throws Exception {
                adminServletTracker.open();
            }

            protected void doStop() throws Exception {
                adminServletTracker.close();
            }
        });
    }

    private SecurityHandler createSecurityHandler(Handler baseHandler, String username, String password) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        ConstraintMapping authenticationContraintMapping = new ConstraintMapping();
        Constraint constraint = new Constraint("BASIC", "admin");
        constraint.setAuthenticate(true);
        authenticationContraintMapping.setConstraint(constraint);
        authenticationContraintMapping.setPathSpec("/*");
        securityHandler.addConstraintMapping(authenticationContraintMapping);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setHandler(baseHandler);
        securityHandler.setLoginService((LoginService)new SimpleAdminLoginService(username, password));
        return securityHandler;
    }

    private HashSessionManager createSessionManager() {
        HashSessionManager sessionManager = new HashSessionManager();
        sessionManager.setMaxInactiveInterval(1200);
        sessionManager.setUsingCookies(false);
        return sessionManager;
    }

    protected void doStart(BundleContext context) throws Exception {
        instance = this;
        this.statusTracker = new StatusTracker(context);
        this.statusTracker.open();
        Job jettyStartJob = new Job("Start Jetty Admin Server"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AdminUiActivator.this.startServer();
                }
                catch (Exception e) {
                    LOG.error("Failed to start Jetty Admin server.", (Throwable)e);
                    ServerApplication.shutdown((Throwable)new IllegalStateException("Unable to start Jetty admin server.", e));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        jettyStartJob.setSystem(true);
        jettyStartJob.setPriority(30);
        jettyStartJob.schedule();
    }

    protected void doStop(BundleContext context) throws Exception {
        instance = null;
        this.statusTracker.close();
        this.statusTracker = null;
        this.stopServer();
    }

    public ImageRegistry getImageRegistry() {
        ImageRegistry imageRegistry = (ImageRegistry)RWT.getUISession().getAttribute(IMAGE_REGISTRY);
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(Display.getCurrent());
            AdminUiImages.initializeImageRegistry(imageRegistry);
            RWT.getUISession().setAttribute(IMAGE_REGISTRY, (Object)imageRegistry);
        }
        return imageRegistry;
    }

    public IStatus getSystemStatus() {
        StatusTracker tracker = this.statusTracker;
        if (tracker == null) {
            throw this.createBundleInactiveException();
        }
        return tracker.getSystemStatus();
    }

    private void startServer() {
        try {
            server = new Server();
            if (Boolean.getBoolean(PROPERTY_ADMIN_SECURE)) {
                this.addSslConnector(server);
            } else {
                this.addNonSslConnector(server);
            }
            server.setStopAtShutdown(true);
            server.setStopTimeout(5000L);
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setSessionHandler(new SessionHandler((SessionManager)this.createSessionManager()));
            this.configureContextWithServletsAndResources(contextHandler);
            String authenticationPhrase = System.getProperty(PROPERTY_ADMIN_AUTH);
            if (Boolean.getBoolean(PROPERTY_ADMIN_SECURE) && StringUtils.isNotBlank((String)authenticationPhrase)) {
                String[] segments = authenticationPhrase.split("/");
                if (segments.length != 3) {
                    throw new IllegalArgumentException("Illegal authentication configuration. Must be three string separated by '/'");
                }
                if (!StringUtils.equals((String)segments[0], (String)"BASIC")) {
                    throw new IllegalArgumentException("Illegal authentication configuration. Only method 'BASIC' is supported. Found " + segments[0]);
                }
                server.setHandler((Handler)this.createSecurityHandler((Handler)contextHandler, segments[1], segments[2]));
            } else {
                server.setHandler((Handler)contextHandler);
            }
            server.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting jetty for admin ui", e);
        }
    }

    private void stopServer() {
        try {
            this.adminApplicationRunner.stop();
            this.adminApplicationRunner = null;
            server.stop();
            server = null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error stopping jetty for admin ui", e);
        }
    }
}

