/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.gyrex.admin.ui.cloud.internal.CloudUiActivator;
import org.eclipse.gyrex.admin.ui.cloud.internal.ConnectToCloudDialog;
import org.eclipse.gyrex.admin.ui.cloud.internal.EditNodeDialog;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodeBrowserContentProvider;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodePatternFilter;
import org.eclipse.gyrex.admin.ui.cloud.internal.ZooKeeperBasedAdminPage;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.PatternFilter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LinkDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ClusterAdminPage
extends ZooKeeperBasedAdminPage {
    private StringDialogField nodeIdField;
    private LinkDialogField membershipStatusField;
    private Button approveButton;
    private Button retireButton;
    private Button editButton;
    private Button manageButton;
    public static final int ID = 0;
    public static final int LOCATION = 1;
    public static final int TAGS = 2;
    public static final int STATUS = 3;

    public ClusterAdminPage() {
        super(4);
        this.setTitle("Cluster Configuration");
        this.setTitleToolTip("Configure the cluster of nodes in the system.");
    }

    void approveSelectedNodes() {
        ICloudManager cloudManager = this.getCloudManager();
        MultiStatus result = new MultiStatus("org.eclipse.gyrex.admin.ui.cloud", 0, "Some nodes could not be approved.", null);
        for (Object object : (IStructuredSelection)this.getTreeViewer().getSelection()) {
            IStatus status;
            NodeBrowserContentProvider.NodeItem nodeItem;
            if (!(object instanceof NodeBrowserContentProvider.NodeItem) || (nodeItem = (NodeBrowserContentProvider.NodeItem)object).isApproved() || (status = cloudManager.approveNode(nodeItem.getDescriptor().getId())).isOK()) continue;
            result.add(status);
        }
        if (!result.isOK()) {
            Policy.getStatusHandler().show((IStatus)result, "Error");
        }
    }

    protected void createButtons(Composite parent) {
        this.approveButton = this.createButton(parent, "Approve");
        this.approveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ClusterAdminPage.this.approveSelectedNodes();
            }
        });
        this.retireButton = this.createButton(parent, "Retire");
        this.retireButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ClusterAdminPage.this.retireSelectedNodes();
            }
        });
        this.createButtonSeparator(parent);
        this.editButton = this.createButton(parent, "Edit..");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ClusterAdminPage.this.editSelectedNode();
            }
        });
        this.manageButton = this.createButton(parent, "Manage");
        this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ClusterAdminPage.this.openSelectedElement();
            }
        });
    }

    private Control createConnectGroup(Composite parent) {
        Infobox infobox = new Infobox(parent);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Clustering in Gyrex.");
        infobox.addParagraph("A Gyrex cluster consists of Gyrex nodes, which are controlled via Apache Zookeeper. To add a node to a cluster, you need to connect it to the central Zookeeper first. After that the new node registers with the cluster but is still in pending mode and needs to be approved to go online.");
        infobox.addParagraph("");
        Composite connectGroup = new Composite((Composite)infobox, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginWidth = 0;
        innerLayout.marginHeight = 0;
        connectGroup.setLayout((Layout)innerLayout);
        connectGroup.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        this.nodeIdField = new StringDialogField(){

            protected Text createTextControl(Composite parent) {
                return new Text(parent, 12);
            }
        };
        this.nodeIdField.setLabelText("Node Id:");
        this.membershipStatusField = new LinkDialogField();
        this.membershipStatusField.setLabelText("Status:");
        LayoutUtil.doDefaultLayout((Composite)connectGroup, (DialogField[])new DialogField[]{this.nodeIdField, this.membershipStatusField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.nodeIdField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.membershipStatusField.getLinkControl(null));
        int heightHint = this.membershipStatusField.getLabelControl(null).computeSize((int)-1, (int)-1).y;
        LayoutUtil.setHeightHint((Control)this.membershipStatusField.getLabelControl(null), (int)heightHint);
        LayoutUtil.setHeightHint((Control)this.membershipStatusField.getLinkControl(null), (int)heightHint);
        this.membershipStatusField.getLinkControl(null).addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if ("#connect".equals(e.text)) {
                    ClusterAdminPage.this.showConnectDialog();
                } else if ("#disconnect".equals(e.text)) {
                    ClusterAdminPage.this.disconnectNode();
                }
            }
        });
        return infobox;
    }

    protected ITreeContentProvider createContentProvider() {
        return new NodeBrowserContentProvider();
    }

    protected Control createHeader(Composite parent) {
        return this.createConnectGroup(parent);
    }

    protected PatternFilter createPatternFilter() {
        return new NodePatternFilter();
    }

    void disconnectNode() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(cloudManager.getLocalInfo().getNodeId());
        IStatus status = nodeConfigurer.configureConnection(null);
        if (!status.isOK()) {
            Policy.getStatusHandler().show(status, "Error Disconnecting Node");
            return;
        }
        this.refresh();
    }

    void editSelectedNode() {
        Object firstElement = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (!(firstElement instanceof NodeBrowserContentProvider.NodeItem)) {
            return;
        }
        EditNodeDialog dialog = new EditNodeDialog(SwtUtil.getShell((Widget)this.membershipStatusField.getLabelControl(null)), this.getCloudManager(), ((NodeBrowserContentProvider.NodeItem)firstElement).getDescriptor());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ClusterAdminPage.this.refresh();
                }
            }
        });
    }

    ICloudManager getCloudManager() {
        return CloudUiActivator.getInstance().getCloudManager();
    }

    protected String getColumnLabel(int column) {
        switch (column) {
            case 0: {
                return "Node";
            }
            case 1: {
                return "Location";
            }
            case 2: {
                return "Tags";
            }
            case 3: {
                return "Status";
            }
        }
        return String.valueOf(column);
    }

    protected String getElementLabel(Object element, int column) {
        if (element instanceof NodeBrowserContentProvider.NodeItem) {
            NodeBrowserContentProvider.NodeItem nodeItem = (NodeBrowserContentProvider.NodeItem)element;
            switch (column) {
                case 0: {
                    return nodeItem.getDescriptor().getId();
                }
                case 1: {
                    return nodeItem.getDescriptor().getLocation();
                }
                case 3: {
                    StrBuilder status = new StrBuilder();
                    if (nodeItem.isApproved()) {
                        status.append("approved");
                    } else {
                        status.append("pending");
                    }
                    if (nodeItem.isOnline()) {
                        status.appendSeparator(", ").append("online");
                    }
                    return status.toString();
                }
                case 2: {
                    return StringUtils.join((Collection)((NodeBrowserContentProvider.NodeItem)element).getDescriptor().getTags(), (String)", ");
                }
            }
        }
        return String.valueOf(element);
    }

    protected String getElementTextForSorting(Object element, int column) {
        if (element instanceof NodeBrowserContentProvider.NodeItem) {
            NodeBrowserContentProvider.NodeItem node = (NodeBrowserContentProvider.NodeItem)element;
            switch (column) {
                case 3: {
                    return node.isApproved() ? (node.isOnline() ? "A1" : "A2") : (node.isOnline() ? "P1" : "P2");
                }
            }
        }
        return super.getElementTextForSorting(element, column);
    }

    protected Object getViewerInput() {
        return this.getCloudManager();
    }

    protected boolean isColumnSortable(int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected void openSelectedElement() {
        Object firstElement = ((IStructuredSelection)this.getTreeViewer().getSelection()).getFirstElement();
        if (!(firstElement instanceof NodeBrowserContentProvider.NodeItem)) {
            return;
        }
        this.getAdminUi().openPage("node", new String[]{((NodeBrowserContentProvider.NodeItem)firstElement).getDescriptor().getId()});
    }

    protected void refresh() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeEnvironment localInfo = cloudManager.getLocalInfo();
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(localInfo.getNodeId());
        this.nodeIdField.setText(localInfo.getNodeId());
        if (localInfo.inStandaloneMode()) {
            this.membershipStatusField.setText("The node operates standalone using an embedded ZooKeeper server. <a href=\"#connect\">Connect it now.</a>");
        } else {
            String serverInfo;
            try {
                serverInfo = ZooKeeperGate.get().getConnectedServerInfo();
            }
            catch (Exception ignored) {
                serverInfo = null;
            }
            String connectString = StringUtils.trimToEmpty((String)nodeConfigurer.getConnectionString());
            if (serverInfo != null) {
                this.membershipStatusField.setText(String.format("The node is connected to %s (using connect string '%s'). <a href=\"#disconnect\">Disconnect it.</a>", serverInfo, StringEscapeUtils.escapeXml((String)connectString)));
            } else {
                this.membershipStatusField.setText(String.format("The node is currently not connected (using connect string '%s'). <a href=\"#disconnect\">Disconnect it.</a>", StringEscapeUtils.escapeXml((String)connectString)));
            }
        }
    }

    void retireSelectedNodes() {
        ICloudManager cloudManager = this.getCloudManager();
        MultiStatus result = new MultiStatus("org.eclipse.gyrex.admin.ui.cloud", 0, "Some nodes could not be retired.", null);
        for (Object object : (IStructuredSelection)this.getTreeViewer().getSelection()) {
            IStatus status;
            NodeBrowserContentProvider.NodeItem nodeItem;
            if (!(object instanceof NodeBrowserContentProvider.NodeItem) || !(nodeItem = (NodeBrowserContentProvider.NodeItem)object).isApproved() || (status = cloudManager.retireNode(nodeItem.getDescriptor().getId())).isOK()) continue;
            result.add(status);
        }
        if (!result.isOK()) {
            Policy.getStatusHandler().show((IStatus)result, "Error");
        }
    }

    void showConnectDialog() {
        ConnectToCloudDialog dialog = new ConnectToCloudDialog(this.getCloudManager(), SwtUtil.getShell((Widget)this.membershipStatusField.getLabelControl(null)));
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ClusterAdminPage.this.refresh();
                }
            }
        });
    }

    protected void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.getTreeViewer().getSelection()).size();
        if (selectedElementsCount == 0) {
            this.approveButton.setEnabled(false);
            this.retireButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.manageButton.setEnabled(false);
            return;
        }
        boolean hasApprovedNodes = false;
        boolean hasPendingNodes = false;
        for (Object object : (IStructuredSelection)this.getTreeViewer().getSelection()) {
            if (object instanceof NodeBrowserContentProvider.NodeItem) {
                NodeBrowserContentProvider.NodeItem nodeItem = (NodeBrowserContentProvider.NodeItem)object;
                hasApprovedNodes |= nodeItem.isApproved();
                hasPendingNodes |= !nodeItem.isApproved();
            }
            if (hasPendingNodes && hasApprovedNodes) break;
        }
        this.approveButton.setEnabled(hasPendingNodes);
        this.retireButton.setEnabled(hasApprovedNodes);
        this.editButton.setEnabled(selectedElementsCount == 1);
        this.manageButton.setEnabled(selectedElementsCount == 1);
    }
}

