/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.jaxrs.internal.JaxRsDebug;
import org.eclipse.gyrex.http.jaxrs.internal.ScanningJaxRsApplication;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsApplicationProviderComponent
extends ApplicationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JaxRsApplicationProviderComponent.class);
    public static final String APPLICATION_PROVIDER_ID = "applicationProviderId";
    private BundleContext bundleContext;

    public void activate(ComponentContext context) {
        block4: {
            if (JaxRsDebug.debug) {
                LOG.debug("JaxRsApplicationProviderComponent activation triggered for component '{}' (bundle {})", context.getProperties().get("component.name"), (Object)context.getBundleContext().getBundle());
            }
            String applicationProviderId = this.getApplicationProviderId(context);
            try {
                if (JaxRsDebug.debug) {
                    LOG.debug("Using application provider id '{}' for component '{}' (bundle {})", new Object[]{applicationProviderId, context.getProperties().get("component.name"), context.getBundleContext().getBundle()});
                }
                this.setId(applicationProviderId);
            }
            catch (IllegalStateException e) {
                if (applicationProviderId.equals(this.getId())) break block4;
                throw new IllegalStateException(String.format("The JaxRsApplicationProviderComponent has already been initialized with an application provider id (%s) and cannot be initialized again with a different id (%s). Please check your component configuration!", this.getId(), applicationProviderId), e);
            }
        }
        this.bundleContext = context.getBundleContext();
    }

    public Application createApplication(String applicationId, IRuntimeContext context) throws CoreException {
        return new ScanningJaxRsApplication(applicationId, context, this.bundleContext.getBundle());
    }

    public void deactivate(ComponentContext context) {
        if (JaxRsDebug.debug) {
            LOG.debug("JaxRsApplicationProviderComponent de-activation triggered for component '{}' (bundle {})", context.getProperties().get("component.name"), (Object)context.getBundleContext().getBundle());
        }
        this.bundleContext = null;
    }

    private String getApplicationProviderId(ComponentContext context) {
        Object applicationProviderIdValue = context.getProperties().get(APPLICATION_PROVIDER_ID);
        if (applicationProviderIdValue == null) {
            return (String)context.getProperties().get("component.name");
        }
        if (!(applicationProviderIdValue instanceof String)) {
            throw new IllegalStateException("The JaxRsApplicationProviderComponent property 'applicationProviderId' must be of type String!");
        }
        return (String)applicationProviderIdValue;
    }
}

