/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.scrolledcompositekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.ScrollBarLCAUtil;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public final class ScrolledCompositeLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ScrolledComposite";
    private static final String[] ALLOWED_STYLES = new String[]{"H_SCROLL", "V_SCROLL", "BORDER"};
    private static final String PARAM_H_BAR_SELECTION = "horizontalBar.selection";
    private static final String PARAM_V_BAR_SELECTION = "verticalBar.selection";
    private static final String PROP_ORIGIN = "origin";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_SHOW_FOCUSED_CONTROL = "showFocusedControl";
    private static final Point DEFAULT_ORIGIN = new Point(0, 0);

    public void preserveValues(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.preserveValues(composite);
        WidgetLCAUtil.preserveCustomVariant(composite);
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_ORIGIN, ScrolledCompositeLCA.getOrigin(composite));
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_CONTENT, composite.getContent());
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl());
        ScrollBarLCAUtil.preserveValues(composite);
    }

    public void readData(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        Point origin = composite.getOrigin();
        String value = WidgetLCAUtil.readPropertyValue(widget, PARAM_H_BAR_SELECTION);
        ScrollBar hScroll = composite.getHorizontalBar();
        if (value != null && hScroll != null) {
            origin.x = NumberFormatUtil.parseInt(value);
        }
        value = WidgetLCAUtil.readPropertyValue(widget, PARAM_V_BAR_SELECTION);
        ScrollBar vScroll = composite.getVerticalBar();
        if (value != null && vScroll != null) {
            origin.y = NumberFormatUtil.parseInt(value);
        }
        composite.setOrigin(origin);
        ControlLCAUtil.processEvents(composite);
        ControlLCAUtil.processKeyEvents(composite);
        ControlLCAUtil.processMenuDetect(composite);
        WidgetLCAUtil.processHelp(composite);
        ScrollBarLCAUtil.processSelectionEvent(composite);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(composite);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(composite.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(composite, ALLOWED_STYLES)));
        ScrollBarLCAUtil.renderInitialization(composite);
    }

    public void renderChanges(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.renderChanges(composite);
        WidgetLCAUtil.renderCustomVariant(composite);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_CONTENT, composite.getContent(), null);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_ORIGIN, ScrolledCompositeLCA.getOrigin(composite), DEFAULT_ORIGIN);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl(), false);
        ScrollBarLCAUtil.renderChanges(composite);
    }

    private static Point getOrigin(ScrolledComposite composite) {
        ScrollBar verticalBar;
        Point result = new Point(0, 0);
        ScrollBar horizontalBar = composite.getHorizontalBar();
        if (horizontalBar != null) {
            result.x = horizontalBar.getSelection();
        }
        if ((verticalBar = composite.getVerticalBar()) != null) {
            result.y = verticalBar.getSelection();
        }
        return result;
    }
}

