/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterException;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rap.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLifeCycleAdapter;
import org.eclipse.swt.internal.widgets.displaykit.DisplayLCA;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class LifeCycleAdapterFactory {
    private final Object displayAdapterLock = new Object();
    private final Object widgetAdaptersLock = new Object();
    private DisplayLifeCycleAdapter displayAdapter;
    private final Map<Class, WidgetLifeCycleAdapter> widgetAdapters = new HashMap<Class, WidgetLifeCycleAdapter>();

    public Object getAdapter(Object adaptable) {
        Object result = null;
        if (adaptable instanceof Display) {
            result = this.getDisplayLCA();
        } else if (adaptable instanceof Widget) {
            result = this.getWidgetLCA(adaptable.getClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisplayLifeCycleAdapter getDisplayLCA() {
        Object object = this.displayAdapterLock;
        synchronized (object) {
            if (this.displayAdapter == null) {
                this.displayAdapter = new DisplayLCA();
            }
            return this.displayAdapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WidgetLifeCycleAdapter getWidgetLCA(Class clazz) {
        WidgetLifeCycleAdapter result;
        Object object = this.widgetAdaptersLock;
        synchronized (object) {
            result = this.widgetAdapters.get(clazz);
            if (result == null) {
                WidgetLifeCycleAdapter adapter = null;
                Class superClass = clazz;
                while (!Object.class.equals((Object)superClass) && adapter == null) {
                    adapter = LifeCycleAdapterFactory.loadWidgetLCA(superClass);
                    if (adapter != null) continue;
                    superClass = superClass.getSuperclass();
                }
                this.widgetAdapters.put(clazz, adapter);
                result = adapter;
            }
        }
        if (result == null) {
            String msg = "Failed to obtain life cycle adapter for: " + clazz.getName();
            throw new LifeCycleAdapterException(msg);
        }
        return result;
    }

    private static WidgetLifeCycleAdapter loadWidgetLCA(Class clazz) {
        WidgetLifeCycleAdapter result = null;
        String className = LifeCycleAdapterUtil.getSimpleClassName(clazz);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(clazz);
        int i = 0;
        while (result == null && i < variants.length) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(variants[i]);
            buffer.append(".");
            buffer.append(className);
            buffer.append("LCA");
            String classToLoad = buffer.toString();
            ClassLoader loader = clazz.getClassLoader();
            try {
                result = (WidgetLifeCycleAdapter)ClassUtil.newInstance(loader, classToLoad);
            }
            catch (ClassInstantiationException classInstantiationException) {}
            ++i;
        }
        return result;
    }
}

