/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.JettyEngineApplication;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandlerCollectionMetrics;
import org.eclipse.gyrex.http.jetty.internal.app.JettyGateway;
import org.eclipse.gyrex.http.jetty.internal.app.UrlMap;
import org.eclipse.gyrex.monitoring.metrics.ThroughputMetric;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandlerCollection
extends AbstractHandlerContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHandlerCollection.class);
    private final AtomicReference<UrlMap> urlMap = new AtomicReference();
    private final CopyOnWriteArrayList<Handler> handlers = new CopyOnWriteArrayList();
    private final JettyGateway jettyGateway;
    private final ApplicationHandlerCollectionMetrics metrics;

    public ApplicationHandlerCollection(JettyGateway jettyGateway) {
        this.jettyGateway = jettyGateway;
        this.metrics = new ApplicationHandlerCollectionMetrics();
        JettyEngineApplication.registerMetrics(this.metrics);
    }

    public boolean addIfAbsent(Handler handler) {
        if (this.handlers.addIfAbsent(handler)) {
            handler.setServer(this.getServer());
            this.metrics.getApplicationsMetric().channelStarted(0L);
            return true;
        }
        return false;
    }

    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            JettyEngineApplication.unregisterMetrics(this.metrics);
        }
    }

    private void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UrlMap map = this.urlMap.get();
        if (map == null) {
            if (JettyDebug.handlers) {
                LOG.debug("null URL map, no handler matched!");
            }
            return;
        }
        PathMap.MappedEntry<Handler> entry = map.getMatch(request.getScheme(), request.getServerName(), request.getServerPort(), target);
        if (entry == null) {
            if (JettyDebug.handlers) {
                LOG.debug("no matching handler for {}", (Object)request.getRequestURL());
            }
            return;
        }
        String oldContextPath = baseRequest.getContextPath();
        try {
            String mapped = entry.getMapped();
            baseRequest.setContextPath(mapped != null && mapped.length() > 0 ? mapped : "/");
            Handler handler = (Handler)entry.getValue();
            if (JettyDebug.handlers) {
                LOG.debug("found matching handler for {}: {}", (Object)request.getRequestURL(), (Object)handler);
                LOG.debug("adjusted context path for {} to {}", (Object)request.getRequestURL(), (Object)baseRequest.getContextPath());
            }
            if (!handler.isStarted()) {
                if (JettyDebug.handlers) {
                    LOG.debug("lazy start of handler {}", (Object)handler);
                }
                try {
                    handler.start();
                }
                catch (Exception e) {
                    if (Platform.inDebugMode()) {
                        LOG.debug("Exception starting handler {}. {}", new Object[]{handler, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                        throw new IllegalStateException(String.format("Failed to start registered handler '%s' for mapping '%s'. %s", handler, mapped, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
                    }
                    LOG.warn("Exception starting handler {}. {}", new Object[]{handler, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                    throw new IllegalStateException("Application Not Available");
                }
            }
            handler.handle(target, baseRequest, request, response);
        }
        finally {
            baseRequest.setContextPath(oldContextPath);
        }
    }

    protected void doStart() throws Exception {
        try {
            super.doStart();
            this.metrics.setStatus("started", "Handler has been started by Jetty");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doStop() throws Exception {
        try {
            super.doStop();
            this.metrics.setStatus("stopped", "Handler has been stopped by Jetty");
        }
        catch (Exception e) {
            this.metrics.error("doStop: " + e.getMessage(), e);
            throw e;
        }
    }

    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        Handler[] handlers = this.getHandlers();
        int i = 0;
        while (handlers != null && i < handlers.length) {
            this.expandHandler(handlers[i], list, byClass);
            ++i;
        }
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray(new Handler[this.handlers.size()]);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block34: {
            if (response.isCommitted() || baseRequest.isHandled()) {
                return;
            }
            Iterator<Handler> handlers = this.handlers.iterator();
            if (!handlers.hasNext()) {
                return;
            }
            ThroughputMetric requestsMetric = this.metrics.getRequestsMetric();
            long requestStart = requestsMetric.requestStarted();
            try {
                this.doHandle(target, baseRequest, request, response);
                if (response instanceof Response) {
                    int status = ((Response)response).getStatus();
                    if (HttpStatus.isServerError((int)status)) {
                        this.metrics.getRequestsMetric().requestFailed();
                        this.metrics.error(status, ((Response)response).getReason());
                    } else {
                        this.metrics.getRequestsMetric().requestFinished(((Response)response).getContentCount(), System.currentTimeMillis() - requestStart);
                    }
                } else {
                    this.metrics.getRequestsMetric().requestFinished(0L, System.currentTimeMillis() - requestStart);
                }
            }
            catch (ContinuationThrowable | EofException | RuntimeIOException e) {
                this.metrics.getRequestsMetric().requestFailed();
                throw e;
            }
            catch (Exception e) {
                this.metrics.getRequestsMetric().requestFailed();
                DispatcherType type = baseRequest.getDispatcherType();
                if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof ServletException) {
                        throw (ServletException)e;
                    }
                } else {
                    if (e instanceof RuntimeIOException) {
                        throw (RuntimeIOException)((Object)e);
                    }
                    if (e instanceof EofException) {
                        throw (EofException)((Object)e);
                    }
                    if (e instanceof IOException || e instanceof UnavailableException || e instanceof IllegalStateException) {
                        if (Platform.inDebugMode()) {
                            LOG.debug("Exception processing request {}: {}", new Object[]{request.getRequestURI(), ExceptionUtils.getMessage((Throwable)e), e});
                            LOG.debug(request.toString());
                        }
                    } else {
                        LOG.error("Exception processing request {}: {}", new Object[]{request.getRequestURI(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                        if (Platform.inDebugMode()) {
                            LOG.debug(request.toString());
                        }
                    }
                }
                if (!response.isCommitted()) {
                    request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                    request.setAttribute("javax.servlet.error.exception", (Object)e);
                    if (e instanceof UnavailableException) {
                        UnavailableException ue = (UnavailableException)e;
                        if (ue.isPermanent()) {
                            response.sendError(404, e.getMessage());
                        } else {
                            response.sendError(503, e.getMessage());
                        }
                    } else if (e instanceof IllegalStateException) {
                        response.sendError(503, e.getMessage());
                    } else {
                        response.sendError(500, e.getMessage());
                    }
                } else if (JettyDebug.debug) {
                    LOG.debug("Response already committed for handling {}", (Object)ExceptionUtils.getMessage((Throwable)e));
                }
            }
            catch (Error e) {
                this.metrics.getRequestsMetric().requestFailed();
                if (!(e instanceof LinkageError) && !(e instanceof AssertionError)) {
                    throw e;
                }
                DispatcherType type = baseRequest.getDispatcherType();
                if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                    throw e;
                }
                LOG.error("Error processing request {}: {}", new Object[]{request.getRequestURI(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                if (JettyDebug.debug) {
                    LOG.debug(request.toString());
                }
                if (!response.isCommitted()) {
                    request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                    request.setAttribute("javax.servlet.error.exception", (Object)e);
                    response.sendError(500, e.getMessage());
                }
                if (!JettyDebug.debug) break block34;
                LOG.debug("Response already committed for handling {}", (Object)ExceptionUtils.getMessage((Throwable)e));
            }
        }
    }

    public void mapUrls() {
        if (JettyDebug.handlers) {
            LOG.debug("remapping urls {}", (Object)this);
        }
        UrlMap urlMap = new UrlMap();
        Handler[] handlers = this.getHandlers();
        int i = 0;
        while (handlers != null && i < handlers.length) {
            String[] urls;
            ApplicationHandler handler = this.jettyGateway.getApplicationHandler(handlers[i]);
            String[] stringArray = urls = handler.getUrls();
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                if (!urlMap.put(url, handlers[i])) {
                    throw new IllegalStateException("conflict detected for url: " + url);
                }
                if (JettyDebug.handlers) {
                    LOG.debug("mapped url {} --> {}", (Object)url, (Object)handlers[i]);
                }
                ++n2;
            }
            ++i;
        }
        this.urlMap.set(urlMap);
    }

    public boolean removeHandler(Handler handler) throws Exception {
        if (this.handlers.remove(handler)) {
            this.metrics.getApplicationsMetric().channelFinished();
            if (handler.isStarted()) {
                handler.stop();
            }
            return true;
        }
        return false;
    }
}

