/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NextProtoNegoServerConnection
extends AbstractConnection
implements NextProtoNego.ServerProvider {
    private final Logger LOG = Log.getLogger(((Object)((Object)this)).getClass());
    private final Connector connector;
    private final SSLEngine engine;
    private final List<String> protocols;
    private final String defaultProtocol;
    private String nextProtocol;

    public NextProtoNegoServerConnection(EndPoint endPoint, SSLEngine engine, Connector connector, List<String> protocols, String defaultProtocol) {
        super(endPoint, connector.getExecutor());
        this.connector = connector;
        this.protocols = protocols;
        this.defaultProtocol = defaultProtocol;
        this.engine = engine;
        NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)this);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onFillable() {
        int filled;
        do {
            if ((filled = this.fill()) != 0 || this.nextProtocol != null) continue;
            this.fillInterested();
        } while (filled > 0 && this.nextProtocol == null);
        if (this.nextProtocol == null && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.LOG.debug("{} missing next protocol. SSLEngine: {}", new Object[]{this, this.engine});
            this.close();
        }
        if (this.nextProtocol != null) {
            ConnectionFactory connectionFactory = this.connector.getConnectionFactory(this.nextProtocol);
            EndPoint endPoint = this.getEndPoint();
            Connection oldConnection = endPoint.getConnection();
            oldConnection.onClose();
            Connection connection = connectionFactory.newConnection(this.connector, endPoint);
            this.LOG.debug("{} switching from {} to {}", new Object[]{this, oldConnection, connection});
            endPoint.setConnection(connection);
            this.getEndPoint().getConnection().onOpen();
        }
    }

    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            this.LOG.debug((Throwable)x);
            NextProtoNego.remove((SSLEngine)this.engine);
            this.getEndPoint().close();
            return -1;
        }
    }

    public void unsupported() {
        this.protocolSelected(this.defaultProtocol);
    }

    public List<String> protocols() {
        return this.protocols;
    }

    public void protocolSelected(String protocol) {
        this.LOG.debug("{} protocol selected {}", new Object[]{this, protocol});
        this.nextProtocol = protocol != null ? protocol : this.defaultProtocol;
        NextProtoNego.remove((SSLEngine)this.engine);
    }
}

