/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.AdminPageWithTree;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.jobs.internal.AddScheduleDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiActivator;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiImages;
import org.eclipse.gyrex.admin.ui.jobs.internal.SchedulesContentProvider;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.definitions.IRuntimeContextDefinitionManager;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.manager.JobHungDetectionHelper;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferncesJobStorage;
import org.eclipse.gyrex.jobs.internal.worker.WorkerEngine;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;

public class BackgroundTasksPage
extends AdminPageWithTree {
    public static final String ID = "background-tasks";
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_TIMEZONE = 1;
    private static final int COLUMN_QUEUE = 2;
    private Button addButton;
    private Button removeButton;
    private Button enableButton;
    private Button disableButton;
    private Button showEntriesButton;
    private Label schedulesMetricLabel;
    private Label jobsRunningLabel;
    private Label jobsWaitingMetricLabel;
    private Label processingStateMetricLabel;

    public BackgroundTasksPage() {
        super(3);
        this.setTitle("Background Tasks");
        this.setTitleToolTip("Browse and manage schedules for executing background tasks.");
    }

    void addButtonPressed() {
        AddScheduleDialog dialog = new AddScheduleDialog(SwtUtil.getShell((Widget)this.addButton));
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    BackgroundTasksPage.this.refresh();
                }
            }
        });
    }

    protected void createButtons(Composite parent) {
        this.addButton = this.createButton(parent, "Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                BackgroundTasksPage.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(parent, "Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                BackgroundTasksPage.this.removeButtonPressed();
            }
        });
        this.createButtonSeparator(parent);
        this.enableButton = this.createButton(parent, "Enable");
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                BackgroundTasksPage.this.enableButtonPressed();
            }
        });
        this.disableButton = this.createButton(parent, "Disable");
        this.disableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                BackgroundTasksPage.this.disableButtonPressed();
            }
        });
        this.createButtonSeparator(parent);
        this.showEntriesButton = this.createButton(parent, "Edit Schedule");
        this.showEntriesButton.setEnabled(false);
        this.showEntriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                BackgroundTasksPage.this.showEntriesButtonPressed();
            }
        });
        this.getTreeViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ScheduleImpl schedule = BackgroundTasksPage.this.getFirstSelectedSchedule(event.getSelection());
                if (schedule != null) {
                    BackgroundTasksPage.this.openScheduleEntriesPage(schedule);
                }
            }
        });
    }

    protected ITreeContentProvider createContentProvider() {
        return new SchedulesContentProvider();
    }

    protected Control createHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.createMetricInfoArea(composite);
        Infobox infobox = new Infobox(composite);
        infobox.addHeading("Schedules");
        infobox.addParagraph("Background tasks in Gyrex are organized into schedules. A schedule is associated to a context and defines common properties (such as timezone) for all background tasks.");
        infobox.addParagraph("Schedules define the jobs to execute as schedule entries. Schedule entries can be triggered using cron expressions or by the successful execution of a preceding entry within the same schedule. Both a schedule as well as individual schedule entries can be enabled or disabled.");
        return composite;
    }

    private void createMetricInfoArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, false));
        area.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(8).create());
        this.schedulesMetricLabel = this.createMetricText(area, "Schedules");
        this.schedulesMetricLabel.setText("0");
        this.createMetricSeparator(area);
        this.jobsRunningLabel = this.createMetricText(area, "Running Jobs");
        this.jobsRunningLabel.setText("0");
        this.createMetricSeparator(area);
        this.jobsWaitingMetricLabel = this.createMetricText(area, "Waiting Jobs");
        this.jobsWaitingMetricLabel.setText("0");
        this.createMetricSeparator(area);
        this.processingStateMetricLabel = this.createMetricText(area, "Worker Engine");
        this.processingStateMetricLabel.setText("?");
    }

    void disableButtonPressed() {
        ScheduleImpl schedule = this.getSelectedSchedule();
        if (schedule == null || !schedule.isEnabled()) {
            return;
        }
        try {
            schedule.setEnabled(false);
            ScheduleStore.flush((String)schedule.getStorageKey(), (ScheduleImpl)schedule);
            schedule.load();
        }
        catch (BackingStoreException e) {
            Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Unable to activate schedule.", (Throwable)e), "Error");
        }
        this.getTreeViewer().refresh((Object)schedule, true);
        this.updateButtons();
    }

    void enableButtonPressed() {
        ScheduleImpl schedule = this.getSelectedSchedule();
        if (schedule == null || schedule.isEnabled()) {
            return;
        }
        try {
            schedule.setEnabled(true);
            ScheduleStore.flush((String)schedule.getStorageKey(), (ScheduleImpl)schedule);
            schedule.load();
        }
        catch (BackingStoreException e) {
            Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Unable to activate schedule.", (Throwable)e), "Error");
        }
        this.getTreeViewer().refresh((Object)schedule, true);
        this.updateButtons();
    }

    protected String getColumnLabel(int column) {
        switch (column) {
            case 0: {
                return "Schedule";
            }
            case 1: {
                return "Time Zone";
            }
            case 2: {
                return "Queue";
            }
        }
        return "";
    }

    protected Image getElementImage(Object element, int column) {
        if (element instanceof ISchedule && column == 0) {
            if (((ISchedule)element).isEnabled()) {
                return JobsUiImages.getImage("obj/schedule_obj.gif");
            }
            return JobsUiImages.getImage("obj/schedule_disabled_obj.gif");
        }
        return null;
    }

    protected String getElementLabel(Object element, int column) {
        if (element instanceof ContextDefinition && column == 0) {
            return ((ContextDefinition)element).getPath().toString();
        }
        if (element instanceof ISchedule) {
            ISchedule schedule = (ISchedule)element;
            switch (column) {
                case 0: {
                    return schedule.getId();
                }
                case 1: {
                    return schedule.getTimeZone().getID();
                }
                case 2: {
                    return this.getQueueName(schedule);
                }
            }
        }
        return "";
    }

    ScheduleImpl getFirstSelectedSchedule(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (!selection.isEmpty() && structuredSelection.getFirstElement() instanceof ScheduleImpl) {
                return (ScheduleImpl)structuredSelection.getFirstElement();
            }
        }
        return null;
    }

    private String getQueueName(ISchedule schedule) {
        if (schedule.getQueueId() == null) {
            return "Default Queue";
        }
        switch (schedule.getQueueId()) {
            case "gyrex.jobs.queue.default": {
                return "Default Queue";
            }
            case "gyrex.jobs.queue.priority": {
                return "Priority Queue";
            }
        }
        return schedule.getQueueId();
    }

    private ScheduleImpl getSelectedSchedule() {
        return this.getFirstSelectedSchedule(this.getTreeViewer().getSelection());
    }

    protected Object getViewerInput() {
        return JobsUiActivator.getInstance().getService(IRuntimeContextDefinitionManager.class);
    }

    protected boolean isColumnSortable(int column) {
        return column == 0;
    }

    void openScheduleEntriesPage(ScheduleImpl schedule) {
        this.getAdminUi().openPage("schedule-entries", new String[]{schedule.getContextPath().toString(), schedule.getId()});
    }

    protected void refresh() {
        this.getTreeViewer().setInput(this.getViewerInput());
    }

    void removeButtonPressed() {
        final ScheduleImpl schedule = this.getSelectedSchedule();
        if (schedule == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.getTreeViewer().getTree()), (String)"Remove selected Schedule", (String)String.format("Do you really want to delete schedule %s?", schedule.getId()), (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                try {
                    ScheduleStore.remove((String)schedule.getStorageKey(), (String)schedule.getId());
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                BackgroundTasksPage.this.refresh();
            }
        });
    }

    void showEntriesButtonPressed() {
        ScheduleImpl schedule = this.getSelectedSchedule();
        if (schedule == null) {
            return;
        }
        this.openScheduleEntriesPage(schedule);
    }

    protected void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.getTreeViewer().getSelection()).size();
        if (selectedElementsCount == 0) {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            this.enableButton.setEnabled(false);
            this.disableButton.setEnabled(false);
            this.showEntriesButton.setEnabled(false);
        } else {
            ScheduleImpl selectedSchedule = this.getSelectedSchedule();
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(selectedElementsCount == 1 && selectedSchedule != null && !selectedSchedule.isEnabled());
            this.showEntriesButton.setEnabled(selectedElementsCount == 1 && selectedSchedule != null && !selectedSchedule.isEnabled());
            if (selectedSchedule != null) {
                if (selectedSchedule.isEnabled()) {
                    this.enableButton.setEnabled(false);
                    this.disableButton.setEnabled(true);
                } else {
                    this.enableButton.setEnabled(true);
                    this.disableButton.setEnabled(false);
                }
            }
        }
        this.updateMetrics();
    }

    private void updateMetrics() {
        try {
            this.schedulesMetricLabel.setText(String.valueOf(ScheduleStore.getSchedules().length));
        }
        catch (Exception e) {
            this.schedulesMetricLabel.setText("n/a");
        }
        try {
            this.jobsRunningLabel.setText(String.valueOf(JobHungDetectionHelper.getNumberOfActiveJobs()));
        }
        catch (Exception e) {
            this.jobsRunningLabel.setText("n/a");
        }
        try {
            this.jobsWaitingMetricLabel.setText(String.valueOf(CloudPreferncesJobStorage.getAllJobStorageKeysByState((JobState)JobState.WAITING).size()));
        }
        catch (Exception e) {
            this.jobsWaitingMetricLabel.setText("n/a");
        }
        try {
            this.processingStateMetricLabel.setText(WorkerEngine.isSuspended() ? "Off" : "On");
        }
        catch (Exception e) {
            this.processingStateMetricLabel.setText("n/a");
        }
    }
}

