/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BeanPropertyHelper {
    static /* synthetic */ Class class$0;

    public static void writeProperty(Object source, PropertyDescriptor propertyDescriptor, Object value) {
        try {
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (writeMethod == null) {
                throw new IllegalArgumentException("Missing public setter method for " + propertyDescriptor.getName() + " property");
            }
            if (!writeMethod.isAccessible()) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(source, value);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", 0, "Could not change value of " + source + "." + propertyDescriptor.getName(), (Throwable)e));
        }
    }

    public static Object readProperty(Object source, PropertyDescriptor propertyDescriptor) {
        try {
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                throw new IllegalArgumentException(String.valueOf(propertyDescriptor.getName()) + " property does not have a read method.");
            }
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(source, null);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", 0, "Could not read value of " + source + "." + propertyDescriptor.getName(), (Throwable)e));
            return null;
        }
    }

    public static Class getCollectionPropertyElementType(PropertyDescriptor descriptor) {
        Class<?> clazz;
        Class<?> propertyType = descriptor.getPropertyType();
        if (propertyType.isArray()) {
            clazz = propertyType.getComponentType();
        } else {
            clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        if (!beanClass.isInterface()) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(beanClass);
            }
            catch (IntrospectionException introspectionException) {
                return null;
            }
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescriptors.length) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                if (descriptor.getName().equals(propertyName)) {
                    return descriptor;
                }
                ++i;
            }
            throw new IllegalArgumentException("Could not find property with name " + propertyName + " in class " + beanClass);
        }
        try {
            ArrayList pds = new ArrayList();
            BeanPropertyHelper.getInterfacePropertyDescriptors(pds, beanClass);
            if (pds.size() <= 0) throw new IllegalArgumentException("Could not find property with name " + propertyName + " in class " + beanClass);
            PropertyDescriptor[] propertyDescriptors = pds.toArray(new PropertyDescriptor[pds.size()]);
            int i = 0;
            while (i < propertyDescriptors.length) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                if (descriptor.getName().equals(propertyName)) {
                    return descriptor;
                }
                ++i;
            }
            throw new IllegalArgumentException("Could not find property with name " + propertyName + " in class " + beanClass);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    private static void getInterfacePropertyDescriptors(List propertyDescriptors, Class iface) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(iface);
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < pds.length) {
            PropertyDescriptor pd = pds[i];
            propertyDescriptors.add(pd);
            ++i;
        }
        Class<?>[] subIntfs = iface.getInterfaces();
        int j = 0;
        while (j < subIntfs.length) {
            BeanPropertyHelper.getInterfacePropertyDescriptors(propertyDescriptors, subIntfs[j]);
            ++j;
        }
    }

    public static PropertyDescriptor getValueTypePropertyDescriptor(IObservableValue observable, String propertyName) {
        if (observable.getValueType() != null) {
            return BeanPropertyHelper.getPropertyDescriptor((Class)observable.getValueType(), propertyName);
        }
        return null;
    }

    public static String propertyName(PropertyDescriptor propertyDescriptor) {
        Class<?> beanClass = propertyDescriptor.getReadMethod().getDeclaringClass();
        return String.valueOf(BeanPropertyHelper.shortClassName(beanClass)) + "." + propertyDescriptor.getName();
    }

    public static String shortClassName(Class beanClass) {
        if (beanClass == null) {
            return "?";
        }
        String className = beanClass.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }
}

