/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.AdminPageRegistry;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.CategoryContribution;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.PageContribution;
import org.eclipse.gyrex.admin.ui.internal.widgets.DropDownItem;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

abstract class DropDownNavigation
extends DropDownItem {
    private static final long serialVersionUID = 1L;
    private final CategoryContribution category;
    private final List<PageContribution> pages;
    private final Menu pullDownMenu;

    private static List<String> getItemLabels(List<PageContribution> pages) {
        ArrayList<String> list = new ArrayList<String>();
        for (PageContribution pageContribution : pages) {
            list.add(pageContribution.getName());
        }
        return list;
    }

    public DropDownNavigation(Composite parent, CategoryContribution category) {
        super(parent, category.getName(), "navigation");
        this.category = category;
        this.pages = AdminPageRegistry.getInstance().getPages(category);
        Collections.sort(this.pages);
        this.pullDownMenu = new Menu((Decorations)parent.getShell(), 8);
        this.pullDownMenu.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getCustomVariant());
        this.createMenuItems(DropDownNavigation.getItemLabels(this.pages));
    }

    private void createMenuItem(final String item) {
        MenuItem menuItem = new MenuItem(this.pullDownMenu, 16392);
        menuItem.setText(item.replace("&", "&&"));
        menuItem.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getCustomVariant());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                DropDownNavigation.this.openItem(item);
            }
        });
    }

    public void createMenuItems(List<String> items) {
        MenuItem[] menuItemArray = this.pullDownMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.dispose();
            ++n2;
        }
        for (String item : items) {
            this.createMenuItem(item);
        }
    }

    public PageContribution findFirstPage() {
        Iterator<PageContribution> iterator = this.pages.iterator();
        if (iterator.hasNext()) {
            PageContribution page = iterator.next();
            return page;
        }
        return null;
    }

    public CategoryContribution getCategory() {
        return this.category;
    }

    @Override
    protected void openDropDown(Point location) {
        if (this.pullDownMenu.getItemCount() == 0) {
            return;
        }
        this.setOpen(true);
        this.pullDownMenu.addMenuListener((MenuListener)new MenuAdapter(){
            private static final long serialVersionUID = 1L;

            public void menuHidden(MenuEvent e) {
                DropDownNavigation.this.setOpen(false);
                DropDownNavigation.this.pullDownMenu.removeMenuListener((MenuListener)this);
            }
        });
        this.pullDownMenu.setLocation(location);
        this.pullDownMenu.setVisible(true);
    }

    protected void openItem(String item) {
        for (PageContribution page : this.pages) {
            if (!item.equals(page.getName())) continue;
            this.openPage(page);
            return;
        }
    }

    protected abstract void openPage(PageContribution var1);
}

