/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.context.IModifiableRuntimeContext;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.BaseContext;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.di.BaseContextInjector;
import org.eclipse.gyrex.context.internal.di.LocalContextInjectorImpl;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalContext
extends BaseContext
implements IModifiableRuntimeContext {
    private static final Logger LOG = LoggerFactory.getLogger(LocalContext.class);
    private final GyrexContextImpl contextImpl;
    private final Map<Class<?>, Object> localObjects = new HashMap();

    public LocalContext(IPath contextPath, ContextRegistryImpl contextRegistry) {
        super(contextPath, contextRegistry);
        this.contextImpl = new GyrexContextImpl(contextPath, contextRegistry){
            private LocalContextInjectorImpl injector;

            @Override
            public void dispose() {
                try {
                    super.dispose();
                }
                finally {
                    this.injector = null;
                }
            }

            @Override
            public IRuntimeContext getHandle() {
                return LocalContext.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BaseContextInjector getInjector() {
                this.checkDisposed();
                this.trackAccess();
                if (this.injector == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.injector == null) {
                            this.injector = new LocalContextInjectorImpl(this, LocalContext.this);
                        }
                    }
                }
                return this.injector;
            }
        };
    }

    @Override
    public IModifiableRuntimeContext createWorkingCopy() throws IllegalStateException {
        throw new IllegalStateException("Creation of nested modifiable contexts is not supported!");
    }

    @Override
    public void dispose() {
        this.contextImpl.dispose();
        this.localObjects.clear();
    }

    @Override
    public GyrexContextImpl get() {
        return this.contextImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type) throws IllegalArgumentException {
        Map<Class<?>, Object> map = this.localObjects;
        synchronized (map) {
            if (this.localObjects.containsKey(type)) {
                T result = type.cast(this.localObjects.get(type));
                LOG.trace("[{}] GET LOCAL: {} -> {}", new Object[]{this, type, result});
                return result;
            }
        }
        return this.get().get(type);
    }

    public <T> T getLocal(Class<T> type) {
        LOG.trace("[{}] GET LOCAL: {}", (Object)this, type);
        return type.cast(this.localObjects.get(type));
    }

    @Override
    public IRuntimeContext getOriginalContext() {
        return this.getContextRegistry().getHandle(this.getContextPath());
    }

    @Override
    public boolean isLocal(Class<?> type) throws IllegalArgumentException {
        return this.localObjects.containsKey(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setLocal(Class<T> type, T value) throws IllegalArgumentException {
        LOG.trace("[{}] SET LOCAL: {}", (Object)this, type);
        Map<Class<?>, Object> map = this.localObjects;
        synchronized (map) {
            this.localObjects.put(type, value);
        }
    }

    @Override
    public String toString() {
        return String.format("%s [WC]", super.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsetLocal(Class<?> type) throws IllegalArgumentException {
        LOG.trace("[{}] UNSET LOCAL: {}", (Object)this, type);
        Map<Class<?>, Object> map = this.localObjects;
        synchronized (map) {
            this.localObjects.remove(type);
        }
    }
}

