/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.handlers;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.StringUtil;

public class DefaultErrorHandlerResourcesHandler
extends AbstractHandler {
    static final String URI_ERROR_IMAGE = "/_error/error.gif";
    static final String URI_WARNING_IMAGE = "/_error/warning.gif";
    static final String URI_INFORMATION_IMAGE = "/_error/information.gif";
    static final String URI_ERROR_CSS = "/_error/error.css";
    static final String URI_GYREX_LOGO = "/_error/gyrex-logo.png";
    static final String MIME_TYPE_ERROR_IMAGE = "image/gif";
    static final String MIME_TYPE_WARNING_IMAGE = "image/gif";
    static final String MIME_TYPE_INFORMATION_IMAGE = "image/gif";
    static final String MIME_TYPE_ERROR_CSS = "text/css;charset=UTF-8";
    static final String MIME_TYPE_GYREX_LOGO = "image/png";
    private final long lastModified;
    private final byte[] errorCss = HttpJettyActivator.readBundleResource("/images/error.css");
    private final byte[] errorGif = HttpJettyActivator.readBundleResource("/images/error.gif");
    private final byte[] informationGif;
    private final byte[] warningGif = HttpJettyActivator.readBundleResource("/images/warning.gif");
    private final byte[] logoPng;

    public DefaultErrorHandlerResourcesHandler() {
        this.informationGif = HttpJettyActivator.readBundleResource("/images/information.gif");
        this.logoPng = HttpJettyActivator.readBundleResource("/images/gyrex-logo.png");
        this.lastModified = System.currentTimeMillis() / 1000L * 1000L;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        boolean headOnly = false;
        if (!HttpMethod.GET.is(request.getMethod())) {
            if (!HttpMethod.HEAD.is(request.getMethod())) {
                return;
            }
            headOnly = true;
        }
        String mimeType = null;
        byte[] resourceBytes = null;
        String requestURI = request.getRequestURI();
        if (StringUtil.endsWithIgnoreCase((String)requestURI, (String)URI_ERROR_CSS)) {
            mimeType = MIME_TYPE_ERROR_CSS;
            resourceBytes = this.errorCss;
        } else if (StringUtil.endsWithIgnoreCase((String)requestURI, (String)URI_ERROR_IMAGE)) {
            mimeType = "image/gif";
            resourceBytes = this.errorGif;
        } else if (StringUtil.endsWithIgnoreCase((String)requestURI, (String)URI_WARNING_IMAGE)) {
            mimeType = "image/gif";
            resourceBytes = this.warningGif;
        } else if (StringUtil.endsWithIgnoreCase((String)requestURI, (String)URI_INFORMATION_IMAGE)) {
            mimeType = "image/gif";
            resourceBytes = this.informationGif;
        } else if (StringUtil.endsWithIgnoreCase((String)requestURI, (String)URI_GYREX_LOGO)) {
            mimeType = MIME_TYPE_GYREX_LOGO;
            resourceBytes = this.logoPng;
        } else {
            return;
        }
        baseRequest.setHandled(true);
        if (request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString()) == this.lastModified) {
            response.setStatus(304);
        } else {
            response.setStatus(200);
            response.setContentType(mimeType);
            response.setContentLength(resourceBytes.length);
            response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), this.lastModified);
            response.setHeader(HttpHeader.CACHE_CONTROL.asString(), "max-age=360000,public");
            if (!headOnly) {
                response.getOutputStream().write(resourceBytes);
            }
        }
    }
}

