/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.provider;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.provider.RuntimeContextObjectProvider;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderRegistration.class);
    private final Class<?> type;
    private final RuntimeContextObjectProvider provider;
    private final ServiceReference serviceReference;
    private final AtomicReference<Dictionary<String, Object>> cachedPropertiesRef = new AtomicReference();
    private final Set<ProviderRegistrationReference> contextReferences = new HashSet<ProviderRegistrationReference>(3);
    private final Lock referencesLock = new ReentrantLock();

    public ProviderRegistration(Class<?> type, RuntimeContextObjectProvider provider, ServiceReference serviceReference) {
        this.type = type;
        this.provider = provider;
        this.serviceReference = serviceReference;
    }

    public void addReference(ProviderRegistrationReference reference) {
        this.referencesLock.lock();
        try {
            this.contextReferences.add(reference);
        }
        finally {
            this.referencesLock.unlock();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderRegistration other = (ProviderRegistration)obj;
        return other.serviceReference == this.serviceReference && other.type == this.type && other.provider == this.provider;
    }

    void flushFromContexts() {
        ProviderRegistrationReference[] references;
        if (ContextDebug.objectLifecycle) {
            LOG.debug("Flushing provider registration {}", (Object)this);
        }
        this.referencesLock.lock();
        try {
            references = this.contextReferences.toArray(new ProviderRegistrationReference[this.contextReferences.size()]);
        }
        finally {
            this.referencesLock.unlock();
        }
        ProviderRegistrationReference[] providerRegistrationReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderRegistrationReference reference = providerRegistrationReferenceArray[n2];
            if (ContextDebug.objectLifecycle) {
                LOG.debug("Flushing provider registration {} from reference {}", (Object)this, (Object)reference);
            }
            reference.flushReference(this);
            ++n2;
        }
    }

    void flushProperties() {
        this.cachedPropertiesRef.set(null);
    }

    public Dictionary<String, Object> getProperties() {
        Dictionary<String, Object> properties = this.cachedPropertiesRef.get();
        if (properties != null) {
            return properties;
        }
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference != null) {
            String[] propertyKeys = serviceReference.getPropertyKeys();
            properties = new Hashtable<String, Object>(2 + propertyKeys.length);
            String[] stringArray = propertyKeys;
            int n = propertyKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                properties.put(key, serviceReference.getProperty(key));
                ++n2;
            }
            properties.put("bundle.name", serviceReference.getBundle().getSymbolicName());
            properties.put("bundle.version", serviceReference.getBundle().getVersion());
        } else {
            properties = new Hashtable<String, Object>(1);
        }
        this.cachedPropertiesRef.set(properties);
        return properties;
    }

    public RuntimeContextObjectProvider getProvider() {
        return this.provider;
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceReference == null ? 0 : this.serviceReference.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        return result;
    }

    public boolean match(Filter filter) {
        if (filter == null) {
            return true;
        }
        return filter.match(this.getProperties());
    }

    public void removeReference(ProviderRegistrationReference reference) {
        this.referencesLock.lock();
        try {
            this.contextReferences.remove(reference);
        }
        finally {
            this.referencesLock.unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProviderRegistration [type=").append(this.type).append(", serviceReference=").append(this.serviceReference).append("]");
        return builder.toString();
    }

    public static interface ProviderRegistrationReference {
        public void flushReference(ProviderRegistration var1);
    }
}

