/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server;

import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.boot.internal.BootActivator;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.osgi.framework.Bundle;

public final class Platform {
    public static IPath getInstanceLocation() throws IllegalStateException {
        return BootActivator.getInstance().getInstanceLocationPath();
    }

    public static int getInstancePort(int port) throws IllegalArgumentException {
        int portOffset = BootActivator.getPortOffset();
        if (portOffset <= 0) {
            return port;
        }
        int translatedPort = port + portOffset;
        if (translatedPort < 0 || translatedPort > 65535) {
            throw new IllegalArgumentException("Instance port out of allowed TCP port range. Please consider lowering port offset.");
        }
        return translatedPort;
    }

    public static IPath getStateLocation(Bundle bundle) throws IllegalStateException {
        return BootActivator.getInstance().getStateLocation(bundle);
    }

    public static boolean inDebugMode() {
        return BootActivator.isDebugMode();
    }

    public static boolean inDevelopmentMode() {
        return BootActivator.isDevMode();
    }

    public static boolean isRunning() {
        return ServerApplication.isRunning();
    }

    private Platform() {
    }
}

