/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.settings;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.server.settings.SystemSettingBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemSetting<T> {
    static final Logger LOG = LoggerFactory.getLogger(SystemSetting.class);
    final String environmentVariable;
    final String systemProperty;
    final String description;
    final T defaultValue;
    final Class<T> valueType;

    public static SystemSettingBuilder<Boolean> newBooleanSetting(String systemProperty, String description) {
        return new SystemSettingBuilder<Boolean>(Boolean.class).systemProperty(systemProperty).description(description);
    }

    public static SystemSettingBuilder<Double> newDoubleSetting(String systemProperty, String description) {
        return new SystemSettingBuilder<Double>(Double.class).systemProperty(systemProperty).description(description);
    }

    public static SystemSettingBuilder<Float> newFloatSetting(String systemProperty, String description) {
        return new SystemSettingBuilder<Float>(Float.class).systemProperty(systemProperty).description(description);
    }

    public static SystemSettingBuilder<Integer> newIntegerSetting(String systemProperty, String description) {
        return new SystemSettingBuilder<Integer>(Integer.class).systemProperty(systemProperty).description(description);
    }

    public static SystemSettingBuilder<Long> newLongSetting(String systemProperty, String description) {
        return new SystemSettingBuilder<Long>(Long.class).systemProperty(systemProperty).description(description);
    }

    public static SystemSettingBuilder<String> newStringSetting(String systemProperty, String description) {
        return new SystemSettingBuilder<String>(String.class).systemProperty(systemProperty).description(description);
    }

    SystemSetting(String environmentVariable, String systemProperty, String description, Class<T> valueType, T defaultValue) {
        if (StringUtils.isBlank((String)environmentVariable)) {
            throw new IllegalArgumentException("Please specify a non blank environment variable!");
        }
        if (StringUtils.isBlank((String)systemProperty)) {
            throw new IllegalArgumentException("Please specify a non blank system property!");
        }
        if (StringUtils.isBlank((String)description)) {
            throw new IllegalArgumentException("Please specify a non blank description!");
        }
        this.environmentVariable = environmentVariable;
        this.systemProperty = systemProperty;
        this.description = description;
        this.valueType = Objects.requireNonNull(valueType, "Please specify a value type!");
        this.defaultValue = defaultValue;
    }

    private T convertToValueType(String value) {
        if (this.valueType.isInstance(value)) {
            return (T)value;
        }
        if (this.valueType.equals(Boolean.class)) {
            return (T)new Boolean(Boolean.parseBoolean(value));
        }
        if (this.valueType.equals(Integer.class)) {
            return (T)new Integer(Integer.parseInt(value));
        }
        if (this.valueType.equals(Long.class)) {
            return (T)new Long(Long.parseLong(value));
        }
        if (this.valueType.equals(Double.class)) {
            return (T)new Double(Double.parseDouble(value));
        }
        if (this.valueType.equals(Float.class)) {
            return (T)new Float(Float.parseFloat(value));
        }
        throw new IllegalArgumentException("Unsupported value type: " + this.valueType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemSetting)) {
            return false;
        }
        SystemSetting other = (SystemSetting)obj;
        return Objects.equals(this.environmentVariable, other.environmentVariable) && Objects.equals(this.systemProperty, other.systemProperty) && Objects.equals(this.description, other.description) && Objects.equals(this.valueType, other.valueType) && Objects.equals(this.defaultValue, other.defaultValue);
    }

    public T get() {
        String value = System.getenv(this.environmentVariable);
        if (value != null) {
            try {
                LOG.debug("Using value {} from environment variable {}", (Object)value, (Object)this.environmentVariable);
                return this.convertToValueType(value);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to parse environment variable '{}': {}", (Object)this.environmentVariable, (Object)e);
            }
        }
        if ((value = System.getProperty(this.systemProperty)) != null) {
            try {
                LOG.debug("Using value {} from system property {}", (Object)value, (Object)this.systemProperty);
                return this.convertToValueType(value);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to parse syste property '{}': {}", (Object)this.systemProperty, (Object)e);
            }
        }
        LOG.debug("No value set for {}/{}, using default value {}", new Object[]{this.environmentVariable, this.systemProperty, this.defaultValue});
        return this.defaultValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getOrFail() throws IllegalArgumentException {
        String value = System.getenv(this.environmentVariable);
        if (value != null) {
            LOG.debug("Using value {} from environment variable {}", (Object)value, (Object)this.environmentVariable);
            return this.convertToValueType(value);
        }
        value = System.getProperty(this.systemProperty);
        if (value != null) {
            LOG.debug("Using value {} from system property {}", (Object)value, (Object)this.systemProperty);
            return this.convertToValueType(value);
        }
        LOG.debug("No value set for {}/{}, using default value {}", new Object[]{this.environmentVariable, this.systemProperty, this.defaultValue});
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.environmentVariable, this.systemProperty, this.description, this.defaultValue, this.valueType);
    }

    public boolean isSet() {
        return System.getenv(this.environmentVariable) != null || System.getProperty(this.systemProperty) != null;
    }

    public boolean isTrue() {
        return Boolean.TRUE.equals(this.get());
    }

    public String toString() {
        return String.format("%s (%s) - %s (default %s)", this.environmentVariable, this.systemProperty, this.description, this.defaultValue);
    }
}

