/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.application.provider;

import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;

public abstract class ApplicationProvider {
    private String id;

    protected ApplicationProvider() {
    }

    protected ApplicationProvider(String id) {
        this.setId(id);
    }

    public abstract Application createApplication(String var1, IRuntimeContext var2) throws Exception;

    public final String getId() {
        if (this.id == null) {
            throw new IllegalStateException(String.format("provider id has not been initialized (%s)", this.getClass().getName()));
        }
        return this.id;
    }

    protected final void setId(String id) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id; please use only ASCII chars a..z (lower and/or upper case), number 0..9 and/or dot, dash and underscore (.-_)");
        }
        this.id = id.intern();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [id=").append(this.id).append("]");
        return builder.toString();
    }
}

