/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.application.manager;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProviderRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProviderRegistration.class);
    private final AtomicReference<ApplicationProvider> provider = new AtomicReference();
    private final List<ApplicationRegistration> activeApplications = new CopyOnWriteArrayList<ApplicationRegistration>();
    private final String contributorInfo;
    private final ServiceReference<ApplicationProvider> reference;
    private final String providerId;

    public ApplicationProviderRegistration(ServiceReference<ApplicationProvider> reference, ApplicationProvider provider) {
        this.reference = reference;
        this.providerId = provider.getId();
        this.provider.set(provider);
        Bundle bundle = reference.getBundle();
        this.contributorInfo = bundle != null ? String.format("%s (%s)", bundle.getSymbolicName(), bundle.getVersion().toString()) : "<unknown>";
    }

    Application createApplication(ApplicationRegistration applicationRegistration) throws Exception {
        ApplicationProvider provider = this.provider.get();
        if (provider == null) {
            return null;
        }
        Application application = provider.createApplication(applicationRegistration.getApplicationId(), applicationRegistration.getContext());
        if (application == null) {
            LOG.error("Provider '{}' did not return an application instance", (Object)provider.getId());
            return null;
        }
        this.activeApplications.add(applicationRegistration);
        return application;
    }

    void destroy() {
        this.provider.set(null);
        for (ApplicationRegistration applicationRegistration : this.activeApplications) {
            applicationRegistration.destroy();
        }
        this.activeApplications.clear();
    }

    public String getContributorInfo() {
        return this.contributorInfo;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getProviderInfo() {
        Object description = this.reference.getProperty("service.description");
        if (description instanceof String) {
            return (String)description;
        }
        return "<unknown>";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApplicationProviderRegistration [");
        ApplicationProvider provider = this.provider.get();
        if (provider != null) {
            builder.append(provider.getId());
            builder.append(", provider=").append(provider);
        } else {
            builder.append("provider=(destroyed)");
        }
        builder.append(", contributedBy=").append(this.contributorInfo).append(", activeApplications=").append(this.activeApplications.size()).append("]");
        return builder.toString();
    }
}

