/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins;

import javax.transaction.UserTransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.ee.jta.UserTransactionHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SchedulerPluginWithUserTransactionSupport
implements SchedulerPlugin {
    private String name;
    private Scheduler scheduler;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean wrapInUserTransaction = false;

    protected void start(UserTransaction userTransaction) {
    }

    protected void shutdown(UserTransaction userTransaction) {
    }

    protected Logger getLog() {
        return this.log;
    }

    protected String getName() {
        return this.name;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.name = name;
        this.scheduler = scheduler;
    }

    public boolean getWrapInUserTransaction() {
        return this.wrapInUserTransaction;
    }

    public void setWrapInUserTransaction(boolean wrapInUserTransaction) {
        this.wrapInUserTransaction = wrapInUserTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.start(userTransaction);
            Object var3_2 = null;
            this.resolveUserTransaction(userTransaction);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.resolveUserTransaction(userTransaction);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        UserTransaction userTransaction = this.startUserTransaction();
        try {
            this.shutdown(userTransaction);
            Object var3_2 = null;
            this.resolveUserTransaction(userTransaction);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.resolveUserTransaction(userTransaction);
            throw throwable;
        }
    }

    private UserTransaction startUserTransaction() {
        if (!this.wrapInUserTransaction) {
            return null;
        }
        UserTransaction userTransaction = null;
        try {
            userTransaction = UserTransactionHelper.lookupUserTransaction();
            userTransaction.begin();
        }
        catch (Throwable t) {
            UserTransactionHelper.returnUserTransaction(userTransaction);
            userTransaction = null;
            this.getLog().error("Failed to start UserTransaction for plugin: " + this.getName(), t);
        }
        return userTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveUserTransaction(UserTransaction userTransaction) {
        if (userTransaction == null) return;
        try {
            try {
                if (userTransaction.getStatus() == 1) {
                    userTransaction.rollback();
                }
                userTransaction.commit();
            }
            catch (Throwable t) {
                this.getLog().error("Failed to resolve UserTransaction for plugin: " + this.getName(), t);
                Object var4_3 = null;
                UserTransactionHelper.returnUserTransaction(userTransaction);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            UserTransactionHelper.returnUserTransaction(userTransaction);
            throw throwable;
        }
        UserTransactionHelper.returnUserTransaction(userTransaction);
    }
}

