/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.externalprocess;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ExternalProcessJobParameter {
    public static final String PARAM_PREFIX_ARG = "arg:";
    public static final String PARAM_PREFIX_ENV = "env:";
    public static final String PARAM_WORKING_DIR = "workingDir";
    public static final String PARAM_EXPECTED_RETURN_CODE = "expectedReturnCode";
    public static final String PARAM_CLEAR_ENVIRONMENT = "clearEnvironment";
    public static final String PARAM_COMMAND = "command";
    public static final String ENV_VALUE_INHERIT = "!INHERIT!";
    private String command = null;
    private Boolean clearEnvironment = null;
    private Integer expectedReturnCode = null;
    private String workingDir = null;
    private Map<String, String> environment;
    private List<String> arguments;

    public static ExternalProcessJobParameter fromParameter(Map<String, String> params, boolean resolveInheritedEnvironmentVariables) {
        ExternalProcessJobParameter p = new ExternalProcessJobParameter();
        TreeMap<String, String> arguments = new TreeMap<String, String>(new ArgumentsParameterKeyComparator());
        HashMap<String, String> environment = new HashMap<String, String>();
        block12: for (Map.Entry<String, String> e : params.entrySet()) {
            String value = e.getValue();
            switch (e.getKey()) {
                case "command": {
                    p.setCommand(value);
                    break;
                }
                case "clearEnvironment": {
                    p.setClearEnvironment(BooleanUtils.toBooleanObject((String)value));
                    break;
                }
                case "expectedReturnCode": {
                    p.setExpectedReturnCode(NumberUtils.toInt((String)value));
                    break;
                }
                case "workingDir": {
                    p.setWorkingDir(value);
                    break;
                }
                default: {
                    if (e.getKey().startsWith(PARAM_PREFIX_ENV)) {
                        String name = e.getKey().substring(PARAM_PREFIX_ENV.length());
                        if (resolveInheritedEnvironmentVariables && StringUtils.equals((String)ENV_VALUE_INHERIT, (String)value)) {
                            value = System.getenv(name);
                        }
                        environment.put(name, value);
                        break;
                    }
                    if (!e.getKey().startsWith(PARAM_PREFIX_ARG)) continue block12;
                    arguments.put(e.getKey().substring(PARAM_PREFIX_ARG.length()), value);
                }
            }
        }
        if (!arguments.isEmpty()) {
            p.setArguments(new ArrayList<String>(arguments.values()));
        }
        if (!environment.isEmpty()) {
            p.setEnvironment(environment);
        }
        return p;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Boolean getClearEnvironment() {
        return this.clearEnvironment;
    }

    public String getCommand() {
        return this.command;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public Integer getExpectedReturnCode() {
        return this.expectedReturnCode;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setClearEnvironment(Boolean clearEnvironment) {
        this.clearEnvironment = clearEnvironment;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void setExpectedReturnCode(Integer expectedReturnCode) {
        this.expectedReturnCode = expectedReturnCode;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Map<String, String> toParameter() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.command)) {
            params.put(PARAM_COMMAND, this.command);
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.size()) {
                params.put(PARAM_PREFIX_ARG + i, String.valueOf(this.arguments.get(i)));
                ++i;
            }
        }
        if (this.environment != null) {
            for (Map.Entry<String, String> e : this.environment.entrySet()) {
                params.put(PARAM_PREFIX_ENV + e.getKey(), e.getValue());
            }
        }
        if (this.clearEnvironment != null) {
            params.put(PARAM_CLEAR_ENVIRONMENT, this.clearEnvironment.toString());
        }
        if (this.expectedReturnCode != null) {
            params.put(PARAM_EXPECTED_RETURN_CODE, this.expectedReturnCode.toString());
        }
        if (StringUtils.isNotBlank((String)this.workingDir)) {
            params.put(PARAM_WORKING_DIR, this.workingDir);
        }
        return params;
    }

    public static final class ArgumentsParameterKeyComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            int i1 = NumberUtils.toInt((String)o1, (int)Integer.MAX_VALUE);
            int i2 = NumberUtils.toInt((String)o2, (int)Integer.MAX_VALUE);
            return i1 - i2;
        }
    }
}

