/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.util.Version;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexConfig {
    public static final Logger log = LoggerFactory.getLogger(SolrIndexConfig.class);
    public static final String defaultsName = "indexDefaults";
    final String defaultMergePolicyClassName;
    public static final String DEFAULT_MERGE_SCHEDULER_CLASSNAME = ConcurrentMergeScheduler.class.getName();
    static final SolrIndexConfig defaultDefaults = new SolrIndexConfig();
    public final Version luceneVersion;
    public final boolean useCompoundFile;
    public final int maxBufferedDocs;
    public final int maxMergeDocs;
    public final int mergeFactor;
    public final double ramBufferSizeMB;
    public final int maxFieldLength;
    public final int writeLockTimeout;
    public final String lockType;
    public final PluginInfo mergePolicyInfo;
    public final PluginInfo mergeSchedulerInfo;
    public final int termIndexInterval;
    public String infoStreamFile = null;

    private SolrIndexConfig() {
        this.luceneVersion = Version.LUCENE_31;
        this.useCompoundFile = true;
        this.maxBufferedDocs = -1;
        this.maxMergeDocs = -1;
        this.mergeFactor = -1;
        this.ramBufferSizeMB = 16.0;
        this.maxFieldLength = -1;
        this.writeLockTimeout = -1;
        this.lockType = null;
        this.termIndexInterval = 128;
        this.mergePolicyInfo = null;
        this.mergeSchedulerInfo = null;
        this.defaultMergePolicyClassName = TieredMergePolicy.class.getName();
    }

    public SolrIndexConfig(SolrConfig solrConfig, String prefix, SolrIndexConfig def) {
        HashMap<String, String> atrs;
        if (prefix == null) {
            prefix = defaultsName;
        }
        if (def == null) {
            def = defaultDefaults;
        }
        this.luceneVersion = solrConfig.luceneMatchVersion;
        this.defaultMergePolicyClassName = this.luceneVersion.onOrAfter(Version.LUCENE_33) ? TieredMergePolicy.class.getName() : LogByteSizeMergePolicy.class.getName();
        this.useCompoundFile = solrConfig.getBool(prefix + "/useCompoundFile", def.useCompoundFile);
        this.maxBufferedDocs = solrConfig.getInt(prefix + "/maxBufferedDocs", def.maxBufferedDocs);
        this.maxMergeDocs = solrConfig.getInt(prefix + "/maxMergeDocs", def.maxMergeDocs);
        this.mergeFactor = solrConfig.getInt(prefix + "/mergeFactor", def.mergeFactor);
        this.ramBufferSizeMB = solrConfig.getDouble(prefix + "/ramBufferSizeMB", def.ramBufferSizeMB);
        this.maxFieldLength = solrConfig.getInt(prefix + "/maxFieldLength", def.maxFieldLength);
        this.writeLockTimeout = solrConfig.getInt(prefix + "/writeLockTimeout", def.writeLockTimeout);
        this.lockType = solrConfig.get(prefix + "/lockType", def.lockType);
        String str = solrConfig.get(prefix + "/mergeScheduler/text()", null);
        if (str != null && str.trim().length() > 0) {
            log.warn("deprecated syntax : <mergeScheduler>[classname]</mergeScheduler>");
            atrs = new HashMap<String, String>();
            atrs.put("class", str.trim());
            this.mergeSchedulerInfo = new PluginInfo("mergeScheduler", atrs, null, null);
        } else {
            this.mergeSchedulerInfo = this.getPluginInfo(prefix + "/mergeScheduler", solrConfig, def.mergeSchedulerInfo);
        }
        str = solrConfig.get(prefix + "/mergePolicy/text()", null);
        if (str != null && str.trim().length() > 0) {
            log.warn("deprecated syntax : <mergePolicy>[classname]</mergePolicy>");
            atrs = new HashMap();
            atrs.put("class", str.trim());
            this.mergePolicyInfo = new PluginInfo("mergePolicy", atrs, null, null);
        } else {
            this.mergePolicyInfo = this.getPluginInfo(prefix + "/mergePolicy", solrConfig, def.mergePolicyInfo);
        }
        String luceneAutoCommit = solrConfig.get(prefix + "/luceneAutoCommit", null);
        if (luceneAutoCommit != null) {
            log.warn("found deprecated option : luceneAutoCommit no longer has any affect - it is always false");
        }
        this.termIndexInterval = solrConfig.getInt(prefix + "/termIndexInterval", def.termIndexInterval);
        boolean infoStreamEnabled = solrConfig.getBool(prefix + "/infoStream", false);
        if (infoStreamEnabled) {
            this.infoStreamFile = solrConfig.get(prefix + "/infoStream/@file", null);
            log.info("IndexWriter infoStream debug log is enabled: " + this.infoStreamFile);
        }
    }

    private PluginInfo getPluginInfo(String path, SolrConfig solrConfig, PluginInfo def) {
        List<PluginInfo> l = solrConfig.readPluginInfos(path, false, true);
        return l.isEmpty() ? def : l.get(0);
    }

    public IndexWriterConfig toIndexWriterConfig(IndexSchema schema) {
        IndexWriterConfig iwc = new IndexWriterConfig(this.luceneVersion, schema.getAnalyzer());
        if (this.maxBufferedDocs != -1) {
            iwc.setMaxBufferedDocs(this.maxBufferedDocs);
        }
        if (this.ramBufferSizeMB != -1.0) {
            iwc.setRAMBufferSizeMB(this.ramBufferSizeMB);
        }
        if (this.termIndexInterval != -1) {
            iwc.setTermIndexInterval(this.termIndexInterval);
        }
        if (this.writeLockTimeout != -1) {
            iwc.setWriteLockTimeout((long)this.writeLockTimeout);
        }
        iwc.setSimilarity(schema.getSimilarity());
        iwc.setMergePolicy(this.buildMergePolicy(schema));
        iwc.setMergeScheduler(this.buildMergeScheduler(schema));
        return iwc;
    }

    private MergePolicy buildMergePolicy(IndexSchema schema) {
        MergePolicy policy;
        String mpClassName = this.mergePolicyInfo == null ? this.defaultMergePolicyClassName : this.mergePolicyInfo.className;
        try {
            policy = (MergePolicy)schema.getResourceLoader().newInstance(mpClassName, null, new Class[]{IndexWriter.class}, new Object[]{this});
        }
        catch (Exception e) {
            policy = (MergePolicy)schema.getResourceLoader().newInstance(mpClassName, new String[0]);
        }
        if (policy instanceof LogMergePolicy) {
            LogMergePolicy logMergePolicy = (LogMergePolicy)policy;
            if (this.maxMergeDocs != -1) {
                logMergePolicy.setMaxMergeDocs(this.maxMergeDocs);
            }
            logMergePolicy.setUseCompoundFile(this.useCompoundFile);
            if (this.mergeFactor != -1) {
                logMergePolicy.setMergeFactor(this.mergeFactor);
            }
        } else if (policy instanceof TieredMergePolicy) {
            TieredMergePolicy tieredMergePolicy = (TieredMergePolicy)policy;
            tieredMergePolicy.setUseCompoundFile(this.useCompoundFile);
            if (this.mergeFactor != -1) {
                tieredMergePolicy.setMaxMergeAtOnce(this.mergeFactor);
                tieredMergePolicy.setSegmentsPerTier((double)this.mergeFactor);
            }
        } else {
            log.warn("Use of compound file format or mergefactor cannot be configured if merge policy is not an instance of LogMergePolicy or TieredMergePolicy. The configured policy's defaults will be used.");
        }
        if (this.mergePolicyInfo != null) {
            SolrPluginUtils.invokeSetters(policy, this.mergePolicyInfo.initArgs);
        }
        return policy;
    }

    private MergeScheduler buildMergeScheduler(IndexSchema schema) {
        String msClassName = this.mergeSchedulerInfo == null ? DEFAULT_MERGE_SCHEDULER_CLASSNAME : this.mergeSchedulerInfo.className;
        MergeScheduler scheduler = (MergeScheduler)schema.getResourceLoader().newInstance(msClassName, new String[0]);
        if (this.mergeSchedulerInfo != null) {
            SolrPluginUtils.invokeSetters(scheduler, this.mergeSchedulerInfo.initArgs);
        }
        return scheduler;
    }
}

