/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.tests.internal;

import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.manager.IRuntimeContextManager;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.context.tests.internal.Activator;
import org.junit.After;
import org.junit.Before;

public abstract class BaseContextTest {
    private IRuntimeContext context;

    protected IRuntimeContext ensureContext(IPath path) {
        ContextRegistryImpl registry = (ContextRegistryImpl)this.getContextRegistry();
        GyrexContextHandle context = registry.get(path);
        if (context != null) {
            return context;
        }
        ContextDefinition definition = new ContextDefinition(path);
        definition.setName("Test Context");
        registry.saveDefinition(definition);
        Assert.assertNotNull((String)"context definition must exists after create", (Object)registry.get(path));
        context = registry.get(path);
        Assert.assertNotNull((String)"context handle must exists", (Object)context);
        Assert.assertNotNull((String)"context handle must map to real context", (Object)context.get());
        return context;
    }

    public IRuntimeContext getContext() {
        return this.context;
    }

    public IRuntimeContextManager getContextManager() {
        return Activator.getActivator().getContextManager();
    }

    public IRuntimeContextRegistry getContextRegistry() {
        return Activator.getActivator().getContextRegistry();
    }

    protected abstract IPath getPrimaryTestContextPath();

    protected void initContext() throws Exception {
    }

    public void setContext(IRuntimeContext context) {
        this.context = context;
    }

    @Before
    public void setUp() throws Exception {
        IPath path = this.getPrimaryTestContextPath();
        if (path != null) {
            this.setContext(this.ensureContext(path));
            this.initContext();
        }
    }

    @After
    public void tearDown() throws Exception {
    }
}

