/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs.internal;

import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.ResourceConfig;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.core.Application;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.jaxrs.JaxRsApplication;
import org.eclipse.gyrex.http.jaxrs.internal.BundleScanningResourceConfig;
import org.eclipse.gyrex.http.jaxrs.internal.JaxRsExtensions;
import org.eclipse.gyrex.http.jaxrs.internal.WebServletScanner;
import org.eclipse.gyrex.http.jaxrs.jersey.spi.inject.ContextServiceInjectableProvider;
import org.eclipse.gyrex.http.jaxrs.jersey.spi.inject.InjectServiceInjectableProvider;
import org.eclipse.gyrex.server.Platform;
import org.osgi.framework.Bundle;

public final class ScanningJaxRsApplication
extends JaxRsApplication {
    private final ResourceConfig resourceConfig;
    private ContextServiceInjectableProvider contextServiceInjector;
    private InjectServiceInjectableProvider injectServiceInjector;
    private final Bundle bundle;

    public ScanningJaxRsApplication(String id, IRuntimeContext context, Bundle bundle) {
        super(id, context);
        this.bundle = bundle;
        this.resourceConfig = new BundleScanningResourceConfig(bundle);
    }

    @Override
    protected Application createJaxRsApplication() {
        if (this.contextServiceInjector != null) {
            this.resourceConfig.getSingletons().add(this.contextServiceInjector);
        }
        if (this.injectServiceInjector != null) {
            this.resourceConfig.getSingletons().add(this.injectServiceInjector);
        }
        JaxRsExtensions.addCommonInjectors(this.resourceConfig.getSingletons(), this.getContext(), this.getApplicationContext());
        JaxRsExtensions.addJsonProviderIfPossible(this.resourceConfig.getSingletons());
        JaxRsExtensions.addWadlSupport(this.resourceConfig);
        this.resourceConfig.getProperties().putAll(this.getApplicationContext().getInitProperties());
        if (Platform.inDevelopmentMode()) {
            if (!this.resourceConfig.getProperties().containsKey("com.sun.jersey.spi.container.ContainerRequestFilters")) {
                this.resourceConfig.getProperties().put("com.sun.jersey.spi.container.ContainerRequestFilters", LoggingFilter.class.getName());
            }
            if (!this.resourceConfig.getProperties().containsKey("com.sun.jersey.spi.container.ContainerResponseFilters")) {
                this.resourceConfig.getProperties().put("com.sun.jersey.spi.container.ContainerResponseFilters", LoggingFilter.class.getName());
            }
            this.resourceConfig.getFeatures().put("com.sun.jersey.config.feature.TracePerRequest", Boolean.TRUE);
        }
        return this.resourceConfig;
    }

    protected void doDestroy() {
        try {
            super.doDestroy();
        }
        finally {
            if (this.contextServiceInjector != null) {
                this.contextServiceInjector.dispose();
                this.contextServiceInjector = null;
            }
            if (this.injectServiceInjector != null) {
                this.injectServiceInjector.dispose();
                this.injectServiceInjector = null;
            }
        }
    }

    @Override
    protected void doInit() throws IllegalStateException, Exception {
        this.contextServiceInjector = new ContextServiceInjectableProvider(this.bundle.getBundleContext());
        this.injectServiceInjector = new InjectServiceInjectableProvider(this.bundle.getBundleContext());
        WebServletScanner servletScanner = new WebServletScanner(this.bundle);
        for (Class<? extends HttpServlet> servletClass : servletScanner.getClasses()) {
            this.getApplicationContext().registerServlet(servletClass);
        }
        super.doInit();
    }
}

