/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs.internal;

import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.spi.container.ReloadListener;
import com.sun.jersey.spi.scanning.AnnotationScannerListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.gyrex.http.jaxrs.internal.BundleScanner;
import org.eclipse.gyrex.http.jaxrs.internal.JaxRsDebug;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServletScanner
implements ReloadListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebServletScanner.class);
    private final Bundle bundle;
    private Set<Class<? extends HttpServlet>> classes;

    public WebServletScanner(Bundle bundle) {
        this.bundle = bundle;
        this.scan();
    }

    public Set<Class<? extends HttpServlet>> getClasses() {
        if (this.classes == null) {
            this.classes = new HashSet<Class<? extends HttpServlet>>();
        }
        return this.classes;
    }

    public void onReload() {
        this.getClasses().clear();
        this.scan();
    }

    private void scan() {
        BundleWiring bundleWiring;
        if (JaxRsDebug.resourceDiscovery) {
            LOG.debug("Scanning bundle '{}' for annotated classes.", (Object)this.bundle);
        }
        if ((bundleWiring = (BundleWiring)this.bundle.adapt(BundleWiring.class)) == null) {
            throw new ScannerException(String.format("No wiring available for bundle '%s'", this.bundle));
        }
        ClassLoader loader = bundleWiring.getClassLoader();
        if (loader == null) {
            throw new ScannerException(String.format("No class loader available for bundle '%s'", this.bundle));
        }
        AnnotationScannerListener scannerListener = new AnnotationScannerListener(loader, new Class[]{WebServlet.class});
        new BundleScanner(this.bundle, bundleWiring, loader).scan((ScannerListener)scannerListener);
        Set annotatedClasses = scannerListener.getAnnotatedClasses();
        if (annotatedClasses.isEmpty()) {
            LOG.warn("No JAX-RS annotated classed found in bundle '{}'.", (Object)this.bundle);
        } else {
            for (Class annotatedClass : annotatedClasses) {
                if (annotatedClass.isAnnotationPresent(WebServlet.class) && HttpServlet.class.isAssignableFrom(annotatedClass)) {
                    if (JaxRsDebug.resourceDiscovery) {
                        LOG.debug("Found servlet: {}", (Object)annotatedClass.getName());
                    }
                    this.getClasses().add(annotatedClass);
                    continue;
                }
                if (!JaxRsDebug.resourceDiscovery) continue;
                LOG.debug("Not a HttpServlet: {}", (Object)annotatedClass.getName());
            }
        }
    }
}

