/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.gyrex.eventbus.IEventHandler;
import org.eclipse.gyrex.eventbus.internal.EventHandler;

public class ReflectionService {
    @VisibleForTesting
    final Set<?> ignoredHierarchyTypes = ImmutableSet.of(Object.class);
    @VisibleForTesting
    final LoadingCache<Class<?>, Set<Class<?>>> classHierarchyByClassCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Set<Class<?>>>(){

        public Set<Class<?>> load(Class<?> key) {
            return ImmutableSet.copyOf((Collection)Collections2.filter((Collection)TypeToken.of(key).getTypes().rawTypes(), (Predicate)Predicates.not((Predicate)Predicates.in(ReflectionService.this.ignoredHierarchyTypes))));
        }
    });

    public void clearCaches() {
        this.classHierarchyByClassCache.invalidateAll();
        this.classHierarchyByClassCache.cleanUp();
    }

    public Set<EventHandler> getEventHandlers(Object object) {
        if (object instanceof IEventHandler) {
            Set<EventHandler> handlers = this.getEventHandlersFromIEventHandler((IEventHandler)object);
            Preconditions.checkArgument((handlers.size() == 1 ? 1 : 0) != 0, (String)"Invalid event handler object (%s). Only one IEventHandler#handleEvent implementation is allowed.", (Object[])new Object[]{object});
            return handlers;
        }
        Set<EventHandler> handlers = this.getEventHandlersFromObjectMethods(object);
        Preconditions.checkArgument((handlers.size() > 0 ? 1 : 0) != 0, (String)"Invalid event handler object (%s). No compliant methods found.", (Object[])new Object[]{object});
        return handlers;
    }

    @VisibleForTesting
    Set<EventHandler> getEventHandlersFromIEventHandler(IEventHandler<Object> eventHandler) {
        HashSet<EventHandler> handlers = new HashSet<EventHandler>();
        Method[] methodArray = eventHandler.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> eventType;
            Method method = methodArray[n2];
            if (method.getName().equals("handleEvent") && method.getParameterTypes().length == 1 && this.isAllowedEventType(eventType = method.getParameterTypes()[0])) {
                handlers.add(EventHandler.of(eventType, eventHandler));
            }
            ++n2;
        }
        return handlers;
    }

    @VisibleForTesting
    Set<EventHandler> getEventHandlersFromObjectMethods(Object object) {
        HashSet<EventHandler> handlers = new HashSet<EventHandler>();
        Method[] methodArray = object.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> eventType;
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(org.eclipse.gyrex.eventbus.EventHandler.class) && method.getParameterTypes().length == 1 && this.isAllowedEventType(eventType = method.getParameterTypes()[0])) {
                handlers.add(EventHandler.of(eventType, method, object));
            }
            ++n2;
        }
        return handlers;
    }

    public Set<Class<?>> getHierarchy(Class<?> clazz) {
        try {
            return (Set)this.classHierarchyByClassCache.get(clazz);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public boolean isAllowedEventType(Class<?> type) {
        return !type.equals(Object.class);
    }
}

