/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.staticresource;

import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.provider.ApplicationProvider;
import org.eclipse.gyrex.http.staticresource.StaticResourceApplication;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceApplicationProvider
extends ApplicationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticResourceApplicationProvider.class);
    public static final String APPLICATION_PROVIDER_ID = "applicationProviderId";
    private BundleContext bundleContext;
    private String bundleResourcePath;
    private String devModeDocRootEnvVar;

    public void activate(ComponentContext context) {
        block2: {
            LOG.debug("StaticResourceApplicationProvider activation triggered for component '{}' (bundle {})", context.getProperties().get("component.name"), (Object)context.getBundleContext().getBundle());
            String applicationProviderId = this.getApplicationProviderId(context);
            try {
                LOG.debug("Using application provider id '{}' for component '{}' (bundle {})", new Object[]{applicationProviderId, context.getProperties().get("component.name"), context.getBundleContext().getBundle()});
                this.setId(applicationProviderId);
            }
            catch (IllegalStateException e) {
                if (applicationProviderId.equals(this.getId())) break block2;
                throw new IllegalStateException(String.format("The StaticResourceApplicationProvider has already been initialized with an application provider id (%s) and cannot be initialized again with a different id (%s). Please check your component configuration!", this.getId(), applicationProviderId), e);
            }
        }
        this.bundleContext = context.getBundleContext();
        this.bundleResourcePath = (String)context.getProperties().get("resource.path");
        this.devModeDocRootEnvVar = (String)context.getProperties().get("resource.devModeDocRootEnvVar");
    }

    @Override
    public Application createApplication(String applicationId, IRuntimeContext context) throws Exception {
        return new StaticResourceApplication(applicationId, context, this.bundleContext.getBundle(), this.bundleResourcePath, this.devModeDocRootEnvVar);
    }

    public void deactivate(ComponentContext context) {
        LOG.debug("StaticResourceApplicationProvider de-activation triggered for component '{}' (bundle {})", context.getProperties().get("component.name"), (Object)context.getBundleContext().getBundle());
        this.bundleContext = null;
    }

    private String getApplicationProviderId(ComponentContext context) {
        Object applicationProviderIdValue = context.getProperties().get(APPLICATION_PROVIDER_ID);
        if (applicationProviderIdValue == null) {
            return (String)context.getProperties().get("component.name");
        }
        if (!(applicationProviderIdValue instanceof String)) {
            throw new IllegalStateException("The StaticResourceApplicationProvider property 'applicationProviderId' must be of type String!");
        }
        return (String)applicationProviderIdValue;
    }
}

