/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.console;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.boot.internal.console.DebugConsoleCommands;
import org.eclipse.gyrex.boot.internal.logback.LogbackConfigurator;
import org.eclipse.gyrex.boot.internal.logback.LogbackLevelDebugOptionsBridge;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class SetCmd
extends Command {
    @Argument(index=0, usage="specify an option name", metaVar="OPTION", required=true)
    String name;
    @Argument(index=1, usage="specify an option value to set (or none to unset)", metaVar="VALUE", required=false)
    String value;
    @Option(name="-trace", aliases={"--enable-full-trace"}, usage="an optional flag to enable all possible log levels of relevant loggers")
    boolean fullTrace;

    public SetCmd() {
        super("<NAME> <VALUE> - sets a debug option");
    }

    protected void doExecute() throws Exception {
        DebugOptions debugOptions = DebugConsoleCommands.getDebugOptions();
        if (this.value == null) {
            debugOptions.removeOption(this.name);
            this.printf("Debug option (%s) has been unset.", new Object[]{this.name});
        } else {
            debugOptions.setOption(this.name, this.value);
            this.printf("Debug option (%s) set to (%s).", new Object[]{this.name, this.value});
        }
        String loggerName = null;
        try {
            loggerName = LogbackLevelDebugOptionsBridge.getLoggerNameForDebugOption(this.name);
            if (loggerName != null) {
                if (this.value != null && !this.value.equalsIgnoreCase("false")) {
                    String level = this.fullTrace ? "ALL" : "DEBUG";
                    LogbackConfigurator.setLogLevelOverride(loggerName, level);
                    this.printf("Log level of logger (%s) updated to (%s).", new Object[]{loggerName, level});
                } else {
                    LogbackConfigurator.setLogLevelOverride(loggerName, null);
                    this.printf("Log level of logger (%s) has been resetted to its default.", new Object[]{loggerName});
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NullPointerException && e.getStackTrace().length > 0 && e.getStackTrace()[0].getMethodName().equals("asJULLevel")) {
                this.printf("Logback logger (%s) was resetted to its default propererly.%nWARNING: Due to LOGBACK-758 the change did not propagate properly to JUL loggers.", new Object[]{loggerName});
            }
            this.printf("WARNING: Unable to update logger (%s). %s", new Object[]{loggerName, ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
    }
}

