/*******************************************************************************
 * Copyright (c) 2013 AGETO Service GmbH and others.
 * All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Contributors:
 *     Gunnar Wagenknecht - initial API and implementation
 *******************************************************************************/
package org.eclipse.gyrex.cloud.internal.zk;

import java.util.concurrent.Callable;


/**
 * Convenience {@link Callable} that provides access to {@link ZooKeeperGate}.
 * 
 * @param <V>
 */
public abstract class ZooKeeperGateCallable<V> implements Callable<V> {
	@Override
	public V call() throws Exception {
		return call(ZooKeeperGate.get());
	}

	protected abstract V call(ZooKeeperGate gate) throws Exception;
}