/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.repositories;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public final class RepositoryDefinition {
    private String id;
    private URI location;
    private String nodeFilter;

    public String getId() {
        return this.id;
    }

    public URI getLocation() {
        return this.location;
    }

    public String getNodeFilter() {
        return this.nodeFilter;
    }

    public void setId(String id) {
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException("invalid id");
        }
        this.id = id;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public void setNodeFilter(String nodeFilter) throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)nodeFilter)) {
            try {
                FrameworkUtil.createFilter((String)nodeFilter);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Invalid node filter. Please use LDAP syntax. " + e.getMessage(), e);
            }
        }
        this.nodeFilter = StringUtils.trimToNull((String)nodeFilter);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("id", (Object)this.id);
        builder.append("location", (Object)this.location);
        builder.append("nodeFilter", (Object)this.nodeFilter);
        return builder.toString();
    }
}

