/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treeitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.treeitemkit.TreeItemOperationHandler;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.GridItem";
    static final String PROP_INDEX = "index";
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_TEXTS = "texts";
    static final String PROP_IMAGES = "images";
    static final String PROP_CELL_BACKGROUNDS = "cellBackgrounds";
    static final String PROP_CELL_FOREGROUNDS = "cellForegrounds";
    static final String PROP_CELL_FONTS = "cellFonts";
    static final String PROP_EXPANDED = "expanded";
    static final String PROP_CHECKED = "checked";
    static final String PROP_GRAYED = "grayed";
    private static final int DEFAULT_ITEM_COUNT = 0;

    public void preserveValues(Widget widget) {
        TreeItem item = (TreeItem)widget;
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_INDEX, TreeItemLCA.getIndex(item));
        if (TreeItemLCA.isCached(item)) {
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_ITEM_COUNT, item.getItemCount());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXTS, TreeItemLCA.getTexts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGES, TreeItemLCA.getImages(item));
            WidgetLCAUtil.preserveBackground(item, TreeItemLCA.getUserBackground(item));
            WidgetLCAUtil.preserveForeground(item, TreeItemLCA.getUserForeground(item));
            WidgetLCAUtil.preserveFont(item, TreeItemLCA.getUserFont(item));
            WidgetLCAUtil.preserveCustomVariant(item);
            WidgetLCAUtil.preserveData(item);
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_BACKGROUNDS, TreeItemLCA.getCellBackgrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FOREGROUNDS, TreeItemLCA.getCellForegrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FONTS, TreeItemLCA.getCellFonts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_EXPANDED, item.getExpanded());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CHECKED, item.getChecked());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_GRAYED, item.getGrayed());
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        TreeItem item = (TreeItem)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(item, TYPE);
        remoteObject.setHandler(new TreeItemOperationHandler(item));
        Widget parent = item.getParentItem() == null ? item.getParent() : item.getParentItem();
        remoteObject.set("parent", WidgetUtil.getId(parent));
    }

    public void renderChanges(Widget widget) throws IOException {
        TreeItem item = (TreeItem)widget;
        WidgetLCAUtil.renderProperty((Widget)item, PROP_INDEX, TreeItemLCA.getIndex(item), -1);
        if (TreeItemLCA.isCached(item)) {
            WidgetLCAUtil.renderProperty((Widget)item, PROP_ITEM_COUNT, item.getItemCount(), 0);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_TEXTS, TreeItemLCA.getTexts(item), TreeItemLCA.getDefaultTexts(item));
            WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGES, TreeItemLCA.getImages(item), new Image[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderBackground(item, TreeItemLCA.getUserBackground(item));
            WidgetLCAUtil.renderForeground(item, TreeItemLCA.getUserForeground(item));
            WidgetLCAUtil.renderFont(item, TreeItemLCA.getUserFont(item));
            WidgetLCAUtil.renderCustomVariant(item);
            WidgetLCAUtil.renderData(item);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_BACKGROUNDS, TreeItemLCA.getCellBackgrounds(item), new Color[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FOREGROUNDS, TreeItemLCA.getCellForegrounds(item), new Color[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FONTS, TreeItemLCA.getCellFonts(item), new Font[TreeItemLCA.getColumnCount(item)]);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_EXPANDED, item.getExpanded(), false);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_CHECKED, item.getChecked(), false);
            WidgetLCAUtil.renderProperty((Widget)item, PROP_GRAYED, item.getGrayed(), false);
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        TreeItem item = (TreeItem)widget;
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        RemoteObject remoteObject = RemoteObjectFactory.getRemoteObject(widget);
        if (!itemAdapter.isParentDisposed()) {
            remoteObject.destroy();
        } else {
            ((RemoteObjectImpl)remoteObject).markDestroyed();
        }
    }

    private static int getIndex(TreeItem item) {
        int result = item.getParentItem() == null ? item.getParent().indexOf(item) : item.getParentItem().indexOf(item);
        return result;
    }

    private static boolean isCached(TreeItem item) {
        Tree tree = item.getParent();
        ITreeAdapter treeAdapter = tree.getAdapter(ITreeAdapter.class);
        return treeAdapter.isCached(item);
    }

    private static String[] getTexts(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        String[] texts = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            texts[i] = item.getText(i);
            ++i;
        }
        return texts;
    }

    private static String[] getDefaultTexts(TreeItem item) {
        String[] result = new String[TreeItemLCA.getColumnCount(item)];
        int i = 0;
        while (i < result.length) {
            result[i] = "";
            ++i;
        }
        return result;
    }

    private static Image[] getImages(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        Image[] images = new Image[columnCount];
        int i = 0;
        while (i < columnCount) {
            images[i] = item.getImage(i);
            ++i;
        }
        return images;
    }

    private static Color getUserBackground(TreeItem item) {
        IWidgetColorAdapter colorAdapter = item.getAdapter(IWidgetColorAdapter.class);
        return colorAdapter.getUserBackground();
    }

    private static Color getUserForeground(TreeItem item) {
        IWidgetColorAdapter colorAdapter = item.getAdapter(IWidgetColorAdapter.class);
        return colorAdapter.getUserForeground();
    }

    private static Font getUserFont(TreeItem item) {
        IWidgetFontAdapter fontAdapter = item.getAdapter(IWidgetFontAdapter.class);
        return fontAdapter.getUserFont();
    }

    private static Color[] getCellBackgrounds(TreeItem item) {
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        return itemAdapter.getCellBackgrounds();
    }

    private static Color[] getCellForegrounds(TreeItem item) {
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        return itemAdapter.getCellForegrounds();
    }

    private static Font[] getCellFonts(TreeItem item) {
        ITreeItemAdapter itemAdapter = item.getAdapter(ITreeItemAdapter.class);
        return itemAdapter.getCellFonts();
    }

    private static int getColumnCount(TreeItem item) {
        return Math.max(1, item.getParent().getColumnCount());
    }
}

