/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.frameworklogadapter.internal;

import java.io.IOException;
import java.net.URLConnection;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.gyrex.frameworklogadapter.internal.GyrexSlf4jForwarder;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;

public class FrameworkLogAdapterHook
implements AdaptorHook {
    public static final String PROP_LOG_ENABLED = "gyrex.log.forwarder.enabled";
    public static final String PROP_BUFFER_SIZE = "gyrex.log.forwarder.buffer.size";
    public static final String PROP_FALLBACK_TO_SYSOUT = "gyrex.log.forwarder.fallback.sysout";
    private static final AtomicReference<FrameworkLogAdapterHook> instanceRef = new AtomicReference();
    private GyrexSlf4jForwarder logForwarder;
    private BundleContext context;
    private final SortedSet<ServiceReference<?>> loggers = new ConcurrentSkipListSet();
    private final ServiceListener slf4jLoggerListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    FrameworkLogAdapterHook.this.registerLogger(event.getServiceReference());
                    break;
                }
                case 4: {
                    FrameworkLogAdapterHook.this.unregisterLogger(event.getServiceReference());
                }
            }
        }
    };
    private final ConcurrentMap<ServiceReference<?>, ExtendedLogReaderService> readerServices = new ConcurrentHashMap();
    private final ServiceListener logReaderServiceListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    FrameworkLogAdapterHook.this.registerWithLogReaderService(event.getServiceReference());
                    break;
                }
                case 4: {
                    FrameworkLogAdapterHook.this.unregisterFromLogReaderService(event.getServiceReference());
                }
            }
        }
    };

    public static FrameworkLogAdapterHook getInstance() {
        FrameworkLogAdapterHook frameworkLogAdapterHook = instanceRef.get();
        while (frameworkLogAdapterHook == null) {
            instanceRef.compareAndSet(null, new FrameworkLogAdapterHook());
            frameworkLogAdapterHook = instanceRef.get();
        }
        return frameworkLogAdapterHook;
    }

    private FrameworkLogAdapterHook() {
    }

    public void addProperties(Properties properties) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        String enabled = System.getProperty(PROP_LOG_ENABLED, "true");
        if (!"true".equals(enabled)) {
            return;
        }
        this.context = context;
        if (this.logForwarder == null) {
            String fallback = System.getProperty(PROP_FALLBACK_TO_SYSOUT);
            if (fallback == null) {
                fallback = Boolean.toString(EclipseStarter.debug);
            }
            this.logForwarder = new GyrexSlf4jForwarder(Integer.getInteger(PROP_BUFFER_SIZE, 0), "true".equals(fallback));
        }
        try {
            context.addServiceListener(this.slf4jLoggerListener, String.format("(& (objectClass=org.slf4j.Logger) (service.pid=org.slf4j.Logger-%s) )", "org.eclipse.equinox.logger"));
            context.addServiceListener(this.logReaderServiceListener, String.format("(& (objectClass=%s) )", ExtendedLogReaderService.class.getName()));
            Collection serviceReferences = context.getServiceReferences(ExtendedLogReaderService.class, null);
            for (ServiceReference serviceReference : serviceReferences) {
                this.registerWithLogReaderService(serviceReference);
            }
        }
        catch (InvalidSyntaxException e) {
            System.err.println("[Eclipse Gyrex] Please inform the developers. There is an implementation error: " + (Object)((Object)e));
        }
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        if (this.logForwarder == null) {
            return;
        }
        context.removeServiceListener(this.slf4jLoggerListener);
        context.removeServiceListener(this.logReaderServiceListener);
        try {
            Collection serviceReferences = context.getServiceReferences(ExtendedLogReaderService.class, null);
            for (ServiceReference serviceReference : serviceReferences) {
                this.unregisterFromLogReaderService(serviceReference);
            }
        }
        catch (InvalidSyntaxException e) {
            System.err.println("[Eclipse Gyrex] Please inform the developers. There is an implementation error: " + (Object)((Object)e));
        }
        this.logForwarder.close();
        this.logForwarder = null;
        this.context = null;
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void handleRuntimeError(Throwable error) {
    }

    public void initialize(BaseAdaptor adaptor) {
    }

    public URLConnection mapLocationToURLConnection(String location) throws IOException {
        return null;
    }

    void registerLogger(ServiceReference serviceReference) {
        this.loggers.add(serviceReference);
        this.updateLogger();
    }

    void registerWithLogReaderService(ServiceReference<?> serviceReference) {
        if (this.logForwarder == null) {
            return;
        }
        ExtendedLogReaderService service = (ExtendedLogReaderService)this.context.getService(serviceReference);
        if (this.readerServices.putIfAbsent(serviceReference, service) == null) {
            service.addLogListener((LogListener)this.logForwarder, (LogFilter)this.logForwarder);
        }
    }

    void unregisterFromLogReaderService(ServiceReference<?> serviceReference) {
        ExtendedLogReaderService removed = (ExtendedLogReaderService)this.readerServices.remove(serviceReference);
        if (removed != null) {
            removed.removeLogListener((LogListener)this.logForwarder);
        }
        this.context.ungetService(serviceReference);
    }

    void unregisterLogger(ServiceReference serviceReference) {
        this.loggers.remove(serviceReference);
        this.updateLogger();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateLogger() {
        ServiceReference<?> highestLoggerReference = null;
        try {
            try {
                highestLoggerReference = this.loggers.last();
                this.logForwarder.setSLF4JLogger(this.context.getService(highestLoggerReference));
                return;
            }
            catch (NoSuchElementException e) {
                this.logForwarder.setSLF4JLogger(null);
                if (highestLoggerReference == null) return;
                this.context.ungetService(highestLoggerReference);
                return;
            }
            catch (RuntimeException e) {
                System.err.printf("[Eclipse Gyrex] Failed to get SLF4J Logger. %s", e.toString());
                if (highestLoggerReference == null) return;
                this.context.ungetService(highestLoggerReference);
                return;
            }
            catch (LinkageError e) {
                System.err.printf("[Eclipse Gyrex] Failed to get SLF4J Logger. %s", e.toString());
                if (highestLoggerReference == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.context.ungetService(highestLoggerReference);
                return;
            }
        }
        finally {
            if (highestLoggerReference != null) {
                this.context.ungetService(highestLoggerReference);
            }
        }
    }
}

