/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.CharSetUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.spi.storage.JobHistoryEntryStorable;

public class StorableBackedJobHistoryEntry
implements IJobHistoryEntry {
    private final JobHistoryEntryStorable storable;
    private final int hashCode;

    private static int calculateHashCode(JobHistoryEntryStorable storable) {
        IStatus status = storable.getResult();
        if (status == null) {
            status = Status.CANCEL_STATUS;
        }
        long timestamp = storable.getTimestamp();
        int prime = 31;
        int result = 1;
        result = 31 * result + status.getMessage().hashCode();
        result = 31 * result + status.getSeverity();
        result = 31 * result + (int)(timestamp ^ timestamp >>> 32);
        return result;
    }

    public StorableBackedJobHistoryEntry(JobHistoryEntryStorable storable) {
        this.storable = storable;
        this.hashCode = StorableBackedJobHistoryEntry.calculateHashCode(storable);
    }

    @Override
    public int compareTo(IJobHistoryEntry o) {
        long otherTimeStamp = o.getTimeStamp();
        if (otherTimeStamp > this.getTimeStamp()) {
            return 1;
        }
        if (otherTimeStamp < this.getTimeStamp()) {
            return -1;
        }
        if (o.getResult().getSeverity() == this.getResult().getSeverity()) {
            return this.getResult().getMessage().compareTo(o.getResult().getMessage());
        }
        return this.getResult().getSeverity() > o.getResult().getSeverity() ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorableBackedJobHistoryEntry other = (StorableBackedJobHistoryEntry)obj;
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (!this.getResult().getMessage().equals(other.getResult().getMessage())) {
            return false;
        }
        return this.getResult().getSeverity() == other.getResult().getSeverity();
    }

    @Override
    public String getCancelledTrigger() {
        return this.storable.getCancelledTrigger();
    }

    @Override
    public Map<String, String> getParameter() {
        Map<String, String> map = this.storable.getParameter();
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public String getQueuedTrigger() {
        return StringUtils.trimToEmpty((String)this.storable.getQueuedTrigger());
    }

    @Override
    public IStatus getResult() {
        return this.storable.getResult() != null ? this.storable.getResult() : Status.CANCEL_STATUS;
    }

    @Override
    public long getTimeStamp() {
        return this.storable.getTimestamp();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(DateFormatUtils.SMTP_DATETIME_FORMAT.format(this.getTimeStamp())).append(" ");
        switch (this.getResult().getSeverity()) {
            case 0: {
                builder.append("OK");
                break;
            }
            case 4: {
                builder.append("ERROR");
                break;
            }
            case 2: {
                builder.append("WARNING");
                break;
            }
            case 1: {
                builder.append("INFO");
                break;
            }
            case 8: {
                builder.append("CANCEL");
                break;
            }
            default: {
                builder.append("severity=");
                builder.append(this.getResult().getSeverity());
            }
        }
        if (StringUtils.isNotBlank((String)this.getResult().getMessage())) {
            builder.append(" ").append(StringUtils.replaceChars((String)CharSetUtils.delete((String)this.getResult().getMessage(), (String)"\t\r\b"), (char)'\n', (char)'|'));
        }
        return builder.toString();
    }
}

