/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferncesJobStorage;
import org.eclipse.gyrex.jobs.internal.util.ContextHashUtil;
import org.eclipse.gyrex.jobs.spi.storage.IJobHistoryStorage;
import org.eclipse.gyrex.jobs.spi.storage.JobHistoryEntryStorable;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPreferncesJobHistoryStorage
implements IJobHistoryStorage {
    private static final String KEY_RESULT_SEVERITY = "resultSeverity";
    private static final String KEY_RESULT_MESSAGE = "resultMessage";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_QUEUED_TRIGGER = "queuedTrigger";
    private static final String KEY_CANCELLED_TRIGGER = "canceledTrigger";
    public static final int MAX_HISTORY_SIZE = 10;
    public static final int MAX_RESULT_MESSAGE_SIZE = (Integer)SystemSetting.newIntegerSetting((String)"gyrex.jobs.history.maxMessageLength", (String)"Maximum length of job result messages to store inthe job history.").usingDefault((Object)4096).create().get();
    private static final Logger LOG = LoggerFactory.getLogger(CloudPreferncesJobHistoryStorage.class);
    private static final String NODE_HISTORY = "history";
    private final ContextHashUtil contextHash;

    private static IStatus convertStatus(IStatus status) {
        return new Status(status.getSeverity(), "org.eclipse.gyrex.jobs", StringUtils.left((String)CloudPreferncesJobHistoryStorage.getFormattedMessage(status, 0), (int)MAX_RESULT_MESSAGE_SIZE));
    }

    private static IStatus deserializeStatus(Preferences node) {
        return new Status(node.getInt(KEY_RESULT_SEVERITY, 8), "org.eclipse.gyrex.jobs", node.get(KEY_RESULT_MESSAGE, ""));
    }

    public static String getFormattedMessage(IStatus status, int ident) {
        StrBuilder builder = new StrBuilder();
        builder.appendPadding(ident, ' ');
        switch (status.getSeverity()) {
            case 8: {
                builder.append("ABORT: ");
                break;
            }
            case 4: {
                builder.append("ERROR: ");
                break;
            }
            case 2: {
                builder.append("WARNING: ");
                break;
            }
            case 1: {
                builder.append("INFO: ");
            }
        }
        builder.append(status.getMessage());
        if (status.getCode() != 0) {
            builder.append(" [code ").append(status.getCode()).append("]");
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                builder.appendNewLine();
                builder.append(CloudPreferncesJobHistoryStorage.getFormattedMessage(child, ident + 2));
                ++n2;
            }
        }
        return builder.toString();
    }

    public static IEclipsePreferences getHistoryNode(String jobStorageKey) throws BackingStoreException {
        return (IEclipsePreferences)CloudPreferncesJobHistoryStorage.getJobsHistoryNode().node(jobStorageKey);
    }

    public static IEclipsePreferences getJobsHistoryNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node(NODE_HISTORY);
    }

    public static JobHistoryEntryStorable readItem(Preferences node) {
        JobHistoryEntryStorable historyEntry = new JobHistoryEntryStorable();
        historyEntry.setTimestamp(node.getLong(KEY_TIMESTAMP, 0L));
        historyEntry.setResult(CloudPreferncesJobHistoryStorage.deserializeStatus(node));
        historyEntry.setQueuedTrigger(node.get(KEY_QUEUED_TRIGGER, ""));
        historyEntry.setCancelledTrigger(node.get(KEY_CANCELLED_TRIGGER, null));
        try {
            historyEntry.setParameter(CloudPreferncesJobStorage.readParameter(node));
        }
        catch (BackingStoreException e) {
            LOG.warn("Failed to read parameter for job history {}. {}", new Object[]{node.absolutePath(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
        return historyEntry;
    }

    private static void serializeStatus(IStatus status, Preferences node) {
        node.put(KEY_RESULT_MESSAGE, CloudPreferncesJobHistoryStorage.convertStatus(status).getMessage());
        node.putInt(KEY_RESULT_SEVERITY, status.getSeverity());
    }

    @Inject
    public CloudPreferncesJobHistoryStorage(IRuntimeContext context) {
        this.contextHash = new ContextHashUtil(context);
    }

    @Override
    public void add(String jobId, JobHistoryEntryStorable historyEntry) throws Exception {
        String entryId;
        IEclipsePreferences historyNode = CloudPreferncesJobHistoryStorage.getHistoryNode(this.contextHash.toInternalId(jobId));
        String[] childrenNames = historyNode.childrenNames();
        TreeSet<JobHistoryEntryStorable> entries = new TreeSet<JobHistoryEntryStorable>();
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            entryId = stringArray[n2];
            entries.add(CloudPreferncesJobHistoryStorage.readItem(historyNode.node(entryId)));
            ++n2;
        }
        entries.add(historyEntry);
        this.shrinkToSizeLimit(entries);
        for (JobHistoryEntryStorable entry : entries) {
            String entryId2 = String.valueOf(entry.getTimestamp());
            if (historyNode.nodeExists(entryId2)) continue;
            Preferences node = historyNode.node(entryId2);
            node.putLong(KEY_TIMESTAMP, entry.getTimestamp());
            CloudPreferncesJobHistoryStorage.serializeStatus(entry.getResult(), node);
            if (entry.getQueuedTrigger() != null) {
                node.put(KEY_QUEUED_TRIGGER, entry.getQueuedTrigger());
            }
            if (entry.getCancelledTrigger() == null) continue;
            node.put(KEY_CANCELLED_TRIGGER, entry.getCancelledTrigger());
        }
        stringArray = historyNode.childrenNames();
        n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            block6: {
                entryId = stringArray[n3];
                for (JobHistoryEntryStorable entry : entries) {
                    if (!entryId.equals(String.valueOf(entry.getTimestamp()))) {
                        continue;
                    }
                    break block6;
                }
                historyNode.node(entryId).removeNode();
            }
            ++n3;
        }
        historyNode.flush();
    }

    @Override
    public int count(String jobId) throws Exception {
        IEclipsePreferences historyNode = CloudPreferncesJobHistoryStorage.getHistoryNode(this.contextHash.toInternalId(jobId));
        String[] childrenNames = historyNode.childrenNames();
        return childrenNames.length;
    }

    @Override
    public Collection<JobHistoryEntryStorable> find(String jobId, int offset, int fetchSize) throws Exception {
        if (offset > 0) {
            return Collections.emptyList();
        }
        IEclipsePreferences historyNode = CloudPreferncesJobHistoryStorage.getHistoryNode(this.contextHash.toInternalId(jobId));
        String[] childrenNames = historyNode.childrenNames();
        TreeSet<JobHistoryEntryStorable> entries = new TreeSet<JobHistoryEntryStorable>();
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String entryId = stringArray[n2];
            entries.add(CloudPreferncesJobHistoryStorage.readItem(historyNode.node(entryId)));
            ++n2;
        }
        this.shrinkToSizeLimit(entries);
        return entries;
    }

    private void shrinkToSizeLimit(SortedSet<JobHistoryEntryStorable> entries) {
        while (entries.size() > 10) {
            entries.remove(entries.last());
        }
    }
}

