/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Alias {
    private static final char UDT_TYPE = 'A';
    private static final char PROCEDURE_TYPE = 'P';
    private static final char FUNCTION_TYPE = 'F';

    public static void doProceduresFunctionsAndUDTs(Connection connection, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT ALIAS, ALIASINFO, ALIASID, SCHEMAID, JAVACLASSNAME, SYSTEMALIAS FROM SYS.SYSALIASES WHERE ALIASTYPE=?");
        if (bl) {
            DB_Alias.generateDDL(preparedStatement, 'A');
        }
        DB_Alias.generateDDL(preparedStatement, 'P');
        DB_Alias.generateDDL(preparedStatement, 'F');
        preparedStatement.close();
    }

    private static void generateDDL(PreparedStatement preparedStatement, char c) throws SQLException {
        preparedStatement.setString(1, new String(new char[]{c}));
        ResultSet resultSet = preparedStatement.executeQuery();
        DB_Alias.generateDDL(resultSet, c);
        resultSet.close();
    }

    private static void generateDDL(ResultSet resultSet, char c) throws SQLException {
        boolean bl = true;
        while (resultSet.next()) {
            String string;
            if (resultSet.getBoolean(6) || dblook.isIgnorableSchema(string = dblook.lookupSchemaId(resultSet.getString(4)))) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                switch (c) {
                    case 'A': {
                        Logs.reportMessage("DBLOOK_UDTHeader");
                        break;
                    }
                    case 'P': {
                        Logs.reportMessage("DBLOOK_StoredProcHeader");
                        break;
                    }
                    case 'F': {
                        Logs.reportMessage("DBLOOK_FunctionHeader");
                    }
                }
                Logs.reportString("----------------------------------------------\n");
            }
            String string2 = resultSet.getString(1);
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(string2));
            string3 = string + "." + string3;
            String string4 = DB_Alias.createProcFuncOrUDTString(string3, resultSet, c);
            Logs.writeToNewDDL(string4);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
    }

    private static String createProcFuncOrUDTString(String string, ResultSet resultSet, char c) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("CREATE ");
        switch (c) {
            case 'A': {
                stringBuffer.append("TYPE ");
                break;
            }
            case 'P': {
                stringBuffer.append("PROCEDURE ");
                break;
            }
            case 'F': {
                stringBuffer.append("FUNCTION ");
            }
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        String string2 = resultSet.getString(2);
        if (c != 'A') {
            stringBuffer.append(string2.substring(string2.indexOf("("), string2.length()));
            stringBuffer.append(" ");
        }
        stringBuffer.append("EXTERNAL NAME '");
        stringBuffer.append(resultSet.getString(5));
        if (c == 'A') {
            stringBuffer.append("' ");
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(".");
            stringBuffer.append(string2.substring(0, string2.indexOf("(")));
            stringBuffer.append("' ");
        }
        return stringBuffer.toString();
    }

    public static void doSynonyms(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ALIAS, SCHEMAID, ALIASINFO, SYSTEMALIAS FROM SYS.SYSALIASES A WHERE ALIASTYPE='S'");
        boolean bl = true;
        while (resultSet.next()) {
            String string;
            if (resultSet.getBoolean(4) || dblook.isIgnorableSchema(string = dblook.lookupSchemaId(resultSet.getString(2)))) continue;
            if (bl) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SynonymHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String string2 = resultSet.getString(1);
            String string3 = dblook.addQuotes(dblook.expandDoubleQuotes(string2));
            string3 = string + "." + string3;
            Logs.writeToNewDDL("CREATE SYNONYM " + string3 + " FOR " + resultSet.getString(3));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            bl = false;
        }
        resultSet.close();
        statement.close();
    }
}

